// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.resourcemanager.sql.models.VulnerabilityAssessmentScanError;
import com.azure.resourcemanager.sql.models.VulnerabilityAssessmentScanState;
import com.azure.resourcemanager.sql.models.VulnerabilityAssessmentScanTriggerType;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

/** Properties of a vulnerability assessment scan record. */
@Immutable
public final class VulnerabilityAssessmentScanRecordProperties {
    /*
     * The scan ID.
     */
    @JsonProperty(value = "scanId", access = JsonProperty.Access.WRITE_ONLY)
    private String scanId;

    /*
     * The scan trigger type.
     */
    @JsonProperty(value = "triggerType", access = JsonProperty.Access.WRITE_ONLY)
    private VulnerabilityAssessmentScanTriggerType triggerType;

    /*
     * The scan status.
     */
    @JsonProperty(value = "state", access = JsonProperty.Access.WRITE_ONLY)
    private VulnerabilityAssessmentScanState state;

    /*
     * The scan start time (UTC).
     */
    @JsonProperty(value = "startTime", access = JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime startTime;

    /*
     * The scan end time (UTC).
     */
    @JsonProperty(value = "endTime", access = JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime endTime;

    /*
     * The scan errors.
     */
    @JsonProperty(value = "errors", access = JsonProperty.Access.WRITE_ONLY)
    private List<VulnerabilityAssessmentScanError> errors;

    /*
     * The scan results storage container path.
     */
    @JsonProperty(value = "storageContainerPath", access = JsonProperty.Access.WRITE_ONLY)
    private String storageContainerPath;

    /*
     * The number of failed security checks.
     */
    @JsonProperty(value = "numberOfFailedSecurityChecks", access = JsonProperty.Access.WRITE_ONLY)
    private Integer numberOfFailedSecurityChecks;

    /**
     * Get the scanId property: The scan ID.
     *
     * @return the scanId value.
     */
    public String scanId() {
        return this.scanId;
    }

    /**
     * Get the triggerType property: The scan trigger type.
     *
     * @return the triggerType value.
     */
    public VulnerabilityAssessmentScanTriggerType triggerType() {
        return this.triggerType;
    }

    /**
     * Get the state property: The scan status.
     *
     * @return the state value.
     */
    public VulnerabilityAssessmentScanState state() {
        return this.state;
    }

    /**
     * Get the startTime property: The scan start time (UTC).
     *
     * @return the startTime value.
     */
    public OffsetDateTime startTime() {
        return this.startTime;
    }

    /**
     * Get the endTime property: The scan end time (UTC).
     *
     * @return the endTime value.
     */
    public OffsetDateTime endTime() {
        return this.endTime;
    }

    /**
     * Get the errors property: The scan errors.
     *
     * @return the errors value.
     */
    public List<VulnerabilityAssessmentScanError> errors() {
        return this.errors;
    }

    /**
     * Get the storageContainerPath property: The scan results storage container path.
     *
     * @return the storageContainerPath value.
     */
    public String storageContainerPath() {
        return this.storageContainerPath;
    }

    /**
     * Get the numberOfFailedSecurityChecks property: The number of failed security checks.
     *
     * @return the numberOfFailedSecurityChecks value.
     */
    public Integer numberOfFailedSecurityChecks() {
        return this.numberOfFailedSecurityChecks;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (errors() != null) {
            errors().forEach(e -> e.validate());
        }
    }
}
