// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.resourcemanager.sql.models.VulnerabilityAssessmentScanError;
import com.azure.resourcemanager.sql.models.VulnerabilityAssessmentScanState;
import com.azure.resourcemanager.sql.models.VulnerabilityAssessmentScanTriggerType;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

/** A vulnerability assessment scan record. */
@Fluent
public final class VulnerabilityAssessmentScanRecordInner extends ProxyResource {
    /*
     * Resource properties.
     */
    @JsonProperty(value = "properties")
    private VulnerabilityAssessmentScanRecordProperties innerProperties;

    /**
     * Get the innerProperties property: Resource properties.
     *
     * @return the innerProperties value.
     */
    private VulnerabilityAssessmentScanRecordProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the scanId property: The scan ID.
     *
     * @return the scanId value.
     */
    public String scanId() {
        return this.innerProperties() == null ? null : this.innerProperties().scanId();
    }

    /**
     * Get the triggerType property: The scan trigger type.
     *
     * @return the triggerType value.
     */
    public VulnerabilityAssessmentScanTriggerType triggerType() {
        return this.innerProperties() == null ? null : this.innerProperties().triggerType();
    }

    /**
     * Get the state property: The scan status.
     *
     * @return the state value.
     */
    public VulnerabilityAssessmentScanState state() {
        return this.innerProperties() == null ? null : this.innerProperties().state();
    }

    /**
     * Get the startTime property: The scan start time (UTC).
     *
     * @return the startTime value.
     */
    public OffsetDateTime startTime() {
        return this.innerProperties() == null ? null : this.innerProperties().startTime();
    }

    /**
     * Get the endTime property: The scan end time (UTC).
     *
     * @return the endTime value.
     */
    public OffsetDateTime endTime() {
        return this.innerProperties() == null ? null : this.innerProperties().endTime();
    }

    /**
     * Get the errors property: The scan errors.
     *
     * @return the errors value.
     */
    public List<VulnerabilityAssessmentScanError> errors() {
        return this.innerProperties() == null ? null : this.innerProperties().errors();
    }

    /**
     * Get the storageContainerPath property: The scan results storage container path.
     *
     * @return the storageContainerPath value.
     */
    public String storageContainerPath() {
        return this.innerProperties() == null ? null : this.innerProperties().storageContainerPath();
    }

    /**
     * Get the numberOfFailedSecurityChecks property: The number of failed security checks.
     *
     * @return the numberOfFailedSecurityChecks value.
     */
    public Integer numberOfFailedSecurityChecks() {
        return this.innerProperties() == null ? null : this.innerProperties().numberOfFailedSecurityChecks();
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
