// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.resourcemanager.sql.models.TransparentDataEncryptionActivityStatus;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Represents the properties of a database transparent data encryption Scan. */
@Immutable
public final class TransparentDataEncryptionActivityProperties {
    /*
     * The status of the database.
     */
    @JsonProperty(value = "status", access = JsonProperty.Access.WRITE_ONLY)
    private TransparentDataEncryptionActivityStatus status;

    /*
     * The percent complete of the transparent data encryption scan for a
     * database.
     */
    @JsonProperty(value = "percentComplete", access = JsonProperty.Access.WRITE_ONLY)
    private Float percentComplete;

    /**
     * Get the status property: The status of the database.
     *
     * @return the status value.
     */
    public TransparentDataEncryptionActivityStatus status() {
        return this.status;
    }

    /**
     * Get the percentComplete property: The percent complete of the transparent data encryption scan for a database.
     *
     * @return the percentComplete value.
     */
    public Float percentComplete() {
        return this.percentComplete;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
