// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.resourcemanager.sql.models.TransparentDataEncryptionActivityStatus;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Represents a database transparent data encryption Scan. */
@Fluent
public final class TransparentDataEncryptionActivityInner extends ProxyResource {
    /*
     * Resource location.
     */
    @JsonProperty(value = "location", access = JsonProperty.Access.WRITE_ONLY)
    private String location;

    /*
     * Represents the properties of the resource.
     */
    @JsonProperty(value = "properties")
    private TransparentDataEncryptionActivityProperties innerProperties;

    /**
     * Get the location property: Resource location.
     *
     * @return the location value.
     */
    public String location() {
        return this.location;
    }

    /**
     * Get the innerProperties property: Represents the properties of the resource.
     *
     * @return the innerProperties value.
     */
    private TransparentDataEncryptionActivityProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the status property: The status of the database.
     *
     * @return the status value.
     */
    public TransparentDataEncryptionActivityStatus status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    /**
     * Get the percentComplete property: The percent complete of the transparent data encryption scan for a database.
     *
     * @return the percentComplete value.
     */
    public Float percentComplete() {
        return this.innerProperties() == null ? null : this.innerProperties().percentComplete();
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
