// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Properties of a TDE certificate. */
@Fluent
public final class TdeCertificateProperties {
    /*
     * The base64 encoded certificate private blob.
     */
    @JsonProperty(value = "privateBlob", required = true)
    private String privateBlob;

    /*
     * The certificate password.
     */
    @JsonProperty(value = "certPassword")
    private String certPassword;

    /**
     * Get the privateBlob property: The base64 encoded certificate private blob.
     *
     * @return the privateBlob value.
     */
    public String privateBlob() {
        return this.privateBlob;
    }

    /**
     * Set the privateBlob property: The base64 encoded certificate private blob.
     *
     * @param privateBlob the privateBlob value to set.
     * @return the TdeCertificateProperties object itself.
     */
    public TdeCertificateProperties withPrivateBlob(String privateBlob) {
        this.privateBlob = privateBlob;
        return this;
    }

    /**
     * Get the certPassword property: The certificate password.
     *
     * @return the certPassword value.
     */
    public String certPassword() {
        return this.certPassword;
    }

    /**
     * Set the certPassword property: The certificate password.
     *
     * @param certPassword the certPassword value to set.
     * @return the TdeCertificateProperties object itself.
     */
    public TdeCertificateProperties withCertPassword(String certPassword) {
        this.certPassword = certPassword;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (privateBlob() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property privateBlob in model TdeCertificateProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(TdeCertificateProperties.class);
}
