// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.resourcemanager.sql.models.SyncGroupLogType;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.UUID;

/** Properties of an Azure SQL Database sync group log. */
@Immutable
public final class SyncGroupLogPropertiesInner {
    /*
     * Timestamp of the sync group log.
     */
    @JsonProperty(value = "timestamp", access = JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime timestamp;

    /*
     * Type of the sync group log.
     */
    @JsonProperty(value = "type", access = JsonProperty.Access.WRITE_ONLY)
    private SyncGroupLogType type;

    /*
     * Source of the sync group log.
     */
    @JsonProperty(value = "source", access = JsonProperty.Access.WRITE_ONLY)
    private String source;

    /*
     * Details of the sync group log.
     */
    @JsonProperty(value = "details", access = JsonProperty.Access.WRITE_ONLY)
    private String details;

    /*
     * TracingId of the sync group log.
     */
    @JsonProperty(value = "tracingId", access = JsonProperty.Access.WRITE_ONLY)
    private UUID tracingId;

    /*
     * OperationStatus of the sync group log.
     */
    @JsonProperty(value = "operationStatus", access = JsonProperty.Access.WRITE_ONLY)
    private String operationStatus;

    /**
     * Get the timestamp property: Timestamp of the sync group log.
     *
     * @return the timestamp value.
     */
    public OffsetDateTime timestamp() {
        return this.timestamp;
    }

    /**
     * Get the type property: Type of the sync group log.
     *
     * @return the type value.
     */
    public SyncGroupLogType type() {
        return this.type;
    }

    /**
     * Get the source property: Source of the sync group log.
     *
     * @return the source value.
     */
    public String source() {
        return this.source;
    }

    /**
     * Get the details property: Details of the sync group log.
     *
     * @return the details value.
     */
    public String details() {
        return this.details;
    }

    /**
     * Get the tracingId property: TracingId of the sync group log.
     *
     * @return the tracingId value.
     */
    public UUID tracingId() {
        return this.tracingId;
    }

    /**
     * Get the operationStatus property: OperationStatus of the sync group log.
     *
     * @return the operationStatus value.
     */
    public String operationStatus() {
        return this.operationStatus;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
