// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.resourcemanager.sql.models.SyncConflictResolutionPolicy;
import com.azure.resourcemanager.sql.models.SyncGroupSchema;
import com.azure.resourcemanager.sql.models.SyncGroupState;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/** An Azure SQL Database sync group. */
@Fluent
public final class SyncGroupInner extends ProxyResource {
    /*
     * Resource properties.
     */
    @JsonProperty(value = "properties")
    private SyncGroupProperties innerProperties;

    /**
     * Get the innerProperties property: Resource properties.
     *
     * @return the innerProperties value.
     */
    private SyncGroupProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the interval property: Sync interval of the sync group.
     *
     * @return the interval value.
     */
    public Integer interval() {
        return this.innerProperties() == null ? null : this.innerProperties().interval();
    }

    /**
     * Set the interval property: Sync interval of the sync group.
     *
     * @param interval the interval value to set.
     * @return the SyncGroupInner object itself.
     */
    public SyncGroupInner withInterval(Integer interval) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SyncGroupProperties();
        }
        this.innerProperties().withInterval(interval);
        return this;
    }

    /**
     * Get the lastSyncTime property: Last sync time of the sync group.
     *
     * @return the lastSyncTime value.
     */
    public OffsetDateTime lastSyncTime() {
        return this.innerProperties() == null ? null : this.innerProperties().lastSyncTime();
    }

    /**
     * Get the conflictResolutionPolicy property: Conflict resolution policy of the sync group.
     *
     * @return the conflictResolutionPolicy value.
     */
    public SyncConflictResolutionPolicy conflictResolutionPolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().conflictResolutionPolicy();
    }

    /**
     * Set the conflictResolutionPolicy property: Conflict resolution policy of the sync group.
     *
     * @param conflictResolutionPolicy the conflictResolutionPolicy value to set.
     * @return the SyncGroupInner object itself.
     */
    public SyncGroupInner withConflictResolutionPolicy(SyncConflictResolutionPolicy conflictResolutionPolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SyncGroupProperties();
        }
        this.innerProperties().withConflictResolutionPolicy(conflictResolutionPolicy);
        return this;
    }

    /**
     * Get the syncDatabaseId property: ARM resource id of the sync database in the sync group.
     *
     * @return the syncDatabaseId value.
     */
    public String syncDatabaseId() {
        return this.innerProperties() == null ? null : this.innerProperties().syncDatabaseId();
    }

    /**
     * Set the syncDatabaseId property: ARM resource id of the sync database in the sync group.
     *
     * @param syncDatabaseId the syncDatabaseId value to set.
     * @return the SyncGroupInner object itself.
     */
    public SyncGroupInner withSyncDatabaseId(String syncDatabaseId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SyncGroupProperties();
        }
        this.innerProperties().withSyncDatabaseId(syncDatabaseId);
        return this;
    }

    /**
     * Get the hubDatabaseUsername property: User name for the sync group hub database credential.
     *
     * @return the hubDatabaseUsername value.
     */
    public String hubDatabaseUsername() {
        return this.innerProperties() == null ? null : this.innerProperties().hubDatabaseUsername();
    }

    /**
     * Set the hubDatabaseUsername property: User name for the sync group hub database credential.
     *
     * @param hubDatabaseUsername the hubDatabaseUsername value to set.
     * @return the SyncGroupInner object itself.
     */
    public SyncGroupInner withHubDatabaseUsername(String hubDatabaseUsername) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SyncGroupProperties();
        }
        this.innerProperties().withHubDatabaseUsername(hubDatabaseUsername);
        return this;
    }

    /**
     * Get the hubDatabasePassword property: Password for the sync group hub database credential.
     *
     * @return the hubDatabasePassword value.
     */
    public String hubDatabasePassword() {
        return this.innerProperties() == null ? null : this.innerProperties().hubDatabasePassword();
    }

    /**
     * Set the hubDatabasePassword property: Password for the sync group hub database credential.
     *
     * @param hubDatabasePassword the hubDatabasePassword value to set.
     * @return the SyncGroupInner object itself.
     */
    public SyncGroupInner withHubDatabasePassword(String hubDatabasePassword) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SyncGroupProperties();
        }
        this.innerProperties().withHubDatabasePassword(hubDatabasePassword);
        return this;
    }

    /**
     * Get the syncState property: Sync state of the sync group.
     *
     * @return the syncState value.
     */
    public SyncGroupState syncState() {
        return this.innerProperties() == null ? null : this.innerProperties().syncState();
    }

    /**
     * Get the schema property: Sync schema of the sync group.
     *
     * @return the schema value.
     */
    public SyncGroupSchema schema() {
        return this.innerProperties() == null ? null : this.innerProperties().schema();
    }

    /**
     * Set the schema property: Sync schema of the sync group.
     *
     * @param schema the schema value to set.
     * @return the SyncGroupInner object itself.
     */
    public SyncGroupInner withSchema(SyncGroupSchema schema) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SyncGroupProperties();
        }
        this.innerProperties().withSchema(schema);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
