// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.resourcemanager.sql.models.SyncMemberDbType;
import com.fasterxml.jackson.annotation.JsonProperty;

/** An Azure SQL Database sync agent linked database. */
@Fluent
public final class SyncAgentLinkedDatabaseInner extends ProxyResource {
    /*
     * Resource properties.
     */
    @JsonProperty(value = "properties")
    private SyncAgentLinkedDatabaseProperties innerProperties;

    /**
     * Get the innerProperties property: Resource properties.
     *
     * @return the innerProperties value.
     */
    private SyncAgentLinkedDatabaseProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the databaseType property: Type of the sync agent linked database.
     *
     * @return the databaseType value.
     */
    public SyncMemberDbType databaseType() {
        return this.innerProperties() == null ? null : this.innerProperties().databaseType();
    }

    /**
     * Get the databaseId property: Id of the sync agent linked database.
     *
     * @return the databaseId value.
     */
    public String databaseId() {
        return this.innerProperties() == null ? null : this.innerProperties().databaseId();
    }

    /**
     * Get the description property: Description of the sync agent linked database.
     *
     * @return the description value.
     */
    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    /**
     * Get the serverName property: Server name of the sync agent linked database.
     *
     * @return the serverName value.
     */
    public String serverName() {
        return this.innerProperties() == null ? null : this.innerProperties().serverName();
    }

    /**
     * Get the databaseName property: Database name of the sync agent linked database.
     *
     * @return the databaseName value.
     */
    public String databaseName() {
        return this.innerProperties() == null ? null : this.innerProperties().databaseName();
    }

    /**
     * Get the username property: User name of the sync agent linked database.
     *
     * @return the username value.
     */
    public String username() {
        return this.innerProperties() == null ? null : this.innerProperties().username();
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
