// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.resourcemanager.sql.models.SyncAgentState;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/** An Azure SQL Database sync agent. */
@Fluent
public final class SyncAgentInner extends ProxyResource {
    /*
     * Resource properties.
     */
    @JsonProperty(value = "properties")
    private SyncAgentProperties innerProperties;

    /**
     * Get the innerProperties property: Resource properties.
     *
     * @return the innerProperties value.
     */
    private SyncAgentProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the name property: Name of the sync agent.
     *
     * @return the name value.
     */
    public String namePropertiesName() {
        return this.innerProperties() == null ? null : this.innerProperties().name();
    }

    /**
     * Get the syncDatabaseId property: ARM resource id of the sync database in the sync agent.
     *
     * @return the syncDatabaseId value.
     */
    public String syncDatabaseId() {
        return this.innerProperties() == null ? null : this.innerProperties().syncDatabaseId();
    }

    /**
     * Set the syncDatabaseId property: ARM resource id of the sync database in the sync agent.
     *
     * @param syncDatabaseId the syncDatabaseId value to set.
     * @return the SyncAgentInner object itself.
     */
    public SyncAgentInner withSyncDatabaseId(String syncDatabaseId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SyncAgentProperties();
        }
        this.innerProperties().withSyncDatabaseId(syncDatabaseId);
        return this;
    }

    /**
     * Get the lastAliveTime property: Last alive time of the sync agent.
     *
     * @return the lastAliveTime value.
     */
    public OffsetDateTime lastAliveTime() {
        return this.innerProperties() == null ? null : this.innerProperties().lastAliveTime();
    }

    /**
     * Get the state property: State of the sync agent.
     *
     * @return the state value.
     */
    public SyncAgentState state() {
        return this.innerProperties() == null ? null : this.innerProperties().state();
    }

    /**
     * Get the isUpToDate property: If the sync agent version is up to date.
     *
     * @return the isUpToDate value.
     */
    public Boolean isUpToDate() {
        return this.innerProperties() == null ? null : this.innerProperties().isUpToDate();
    }

    /**
     * Get the expiryTime property: Expiration time of the sync agent version.
     *
     * @return the expiryTime value.
     */
    public OffsetDateTime expiryTime() {
        return this.innerProperties() == null ? null : this.innerProperties().expiryTime();
    }

    /**
     * Get the version property: Version of the sync agent.
     *
     * @return the version value.
     */
    public String version() {
        return this.innerProperties() == null ? null : this.innerProperties().version();
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
