// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.sql.models.ServerPrivateEndpointConnection;
import com.azure.resourcemanager.sql.models.ServerPublicNetworkAccess;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The properties of a server. */
@Fluent
public final class ServerProperties {
    /*
     * Administrator username for the server. Once created it cannot be
     * changed.
     */
    @JsonProperty(value = "administratorLogin")
    private String administratorLogin;

    /*
     * The administrator login password (required for server creation).
     */
    @JsonProperty(value = "administratorLoginPassword")
    private String administratorLoginPassword;

    /*
     * The version of the server.
     */
    @JsonProperty(value = "version")
    private String version;

    /*
     * The state of the server.
     */
    @JsonProperty(value = "state", access = JsonProperty.Access.WRITE_ONLY)
    private String state;

    /*
     * The fully qualified domain name of the server.
     */
    @JsonProperty(value = "fullyQualifiedDomainName", access = JsonProperty.Access.WRITE_ONLY)
    private String fullyQualifiedDomainName;

    /*
     * List of private endpoint connections on a server
     */
    @JsonProperty(value = "privateEndpointConnections", access = JsonProperty.Access.WRITE_ONLY)
    private List<ServerPrivateEndpointConnection> privateEndpointConnections;

    /*
     * Minimal TLS version. Allowed values: '1.0', '1.1', '1.2'
     */
    @JsonProperty(value = "minimalTlsVersion")
    private String minimalTlsVersion;

    /*
     * Whether or not public endpoint access is allowed for this server.  Value
     * is optional but if passed in, must be 'Enabled' or 'Disabled'
     */
    @JsonProperty(value = "publicNetworkAccess")
    private ServerPublicNetworkAccess publicNetworkAccess;

    /**
     * Get the administratorLogin property: Administrator username for the server. Once created it cannot be changed.
     *
     * @return the administratorLogin value.
     */
    public String administratorLogin() {
        return this.administratorLogin;
    }

    /**
     * Set the administratorLogin property: Administrator username for the server. Once created it cannot be changed.
     *
     * @param administratorLogin the administratorLogin value to set.
     * @return the ServerProperties object itself.
     */
    public ServerProperties withAdministratorLogin(String administratorLogin) {
        this.administratorLogin = administratorLogin;
        return this;
    }

    /**
     * Get the administratorLoginPassword property: The administrator login password (required for server creation).
     *
     * @return the administratorLoginPassword value.
     */
    public String administratorLoginPassword() {
        return this.administratorLoginPassword;
    }

    /**
     * Set the administratorLoginPassword property: The administrator login password (required for server creation).
     *
     * @param administratorLoginPassword the administratorLoginPassword value to set.
     * @return the ServerProperties object itself.
     */
    public ServerProperties withAdministratorLoginPassword(String administratorLoginPassword) {
        this.administratorLoginPassword = administratorLoginPassword;
        return this;
    }

    /**
     * Get the version property: The version of the server.
     *
     * @return the version value.
     */
    public String version() {
        return this.version;
    }

    /**
     * Set the version property: The version of the server.
     *
     * @param version the version value to set.
     * @return the ServerProperties object itself.
     */
    public ServerProperties withVersion(String version) {
        this.version = version;
        return this;
    }

    /**
     * Get the state property: The state of the server.
     *
     * @return the state value.
     */
    public String state() {
        return this.state;
    }

    /**
     * Get the fullyQualifiedDomainName property: The fully qualified domain name of the server.
     *
     * @return the fullyQualifiedDomainName value.
     */
    public String fullyQualifiedDomainName() {
        return this.fullyQualifiedDomainName;
    }

    /**
     * Get the privateEndpointConnections property: List of private endpoint connections on a server.
     *
     * @return the privateEndpointConnections value.
     */
    public List<ServerPrivateEndpointConnection> privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    /**
     * Get the minimalTlsVersion property: Minimal TLS version. Allowed values: '1.0', '1.1', '1.2'.
     *
     * @return the minimalTlsVersion value.
     */
    public String minimalTlsVersion() {
        return this.minimalTlsVersion;
    }

    /**
     * Set the minimalTlsVersion property: Minimal TLS version. Allowed values: '1.0', '1.1', '1.2'.
     *
     * @param minimalTlsVersion the minimalTlsVersion value to set.
     * @return the ServerProperties object itself.
     */
    public ServerProperties withMinimalTlsVersion(String minimalTlsVersion) {
        this.minimalTlsVersion = minimalTlsVersion;
        return this;
    }

    /**
     * Get the publicNetworkAccess property: Whether or not public endpoint access is allowed for this server. Value is
     * optional but if passed in, must be 'Enabled' or 'Disabled'.
     *
     * @return the publicNetworkAccess value.
     */
    public ServerPublicNetworkAccess publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    /**
     * Set the publicNetworkAccess property: Whether or not public endpoint access is allowed for this server. Value is
     * optional but if passed in, must be 'Enabled' or 'Disabled'.
     *
     * @param publicNetworkAccess the publicNetworkAccess value to set.
     * @return the ServerProperties object itself.
     */
    public ServerProperties withPublicNetworkAccess(ServerPublicNetworkAccess publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (privateEndpointConnections() != null) {
            privateEndpointConnections().forEach(e -> e.validate());
        }
    }
}
