// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The properties of a server communication link. */
@Fluent
public final class ServerCommunicationLinkProperties {
    /*
     * The state.
     */
    @JsonProperty(value = "state", access = JsonProperty.Access.WRITE_ONLY)
    private String state;

    /*
     * The name of the partner server.
     */
    @JsonProperty(value = "partnerServer", required = true)
    private String partnerServer;

    /**
     * Get the state property: The state.
     *
     * @return the state value.
     */
    public String state() {
        return this.state;
    }

    /**
     * Get the partnerServer property: The name of the partner server.
     *
     * @return the partnerServer value.
     */
    public String partnerServer() {
        return this.partnerServer;
    }

    /**
     * Set the partnerServer property: The name of the partner server.
     *
     * @param partnerServer the partnerServer value to set.
     * @return the ServerCommunicationLinkProperties object itself.
     */
    public ServerCommunicationLinkProperties withPartnerServer(String partnerServer) {
        this.partnerServer = partnerServer;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (partnerServer() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property partnerServer in model ServerCommunicationLinkProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ServerCommunicationLinkProperties.class);
}
