// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Server communication link. */
@Fluent
public final class ServerCommunicationLinkInner extends ProxyResource {
    /*
     * The properties of resource.
     */
    @JsonProperty(value = "properties")
    private ServerCommunicationLinkProperties innerProperties;

    /*
     * Communication link location.
     */
    @JsonProperty(value = "location", access = JsonProperty.Access.WRITE_ONLY)
    private String location;

    /*
     * Communication link kind.  This property is used for Azure Portal
     * metadata.
     */
    @JsonProperty(value = "kind", access = JsonProperty.Access.WRITE_ONLY)
    private String kind;

    /**
     * Get the innerProperties property: The properties of resource.
     *
     * @return the innerProperties value.
     */
    private ServerCommunicationLinkProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the location property: Communication link location.
     *
     * @return the location value.
     */
    public String location() {
        return this.location;
    }

    /**
     * Get the kind property: Communication link kind. This property is used for Azure Portal metadata.
     *
     * @return the kind value.
     */
    public String kind() {
        return this.kind;
    }

    /**
     * Get the state property: The state.
     *
     * @return the state value.
     */
    public String state() {
        return this.innerProperties() == null ? null : this.innerProperties().state();
    }

    /**
     * Get the partnerServer property: The name of the partner server.
     *
     * @return the partnerServer value.
     */
    public String partnerServer() {
        return this.innerProperties() == null ? null : this.innerProperties().partnerServer();
    }

    /**
     * Set the partnerServer property: The name of the partner server.
     *
     * @param partnerServer the partnerServer value to set.
     * @return the ServerCommunicationLinkInner object itself.
     */
    public ServerCommunicationLinkInner withPartnerServer(String partnerServer) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerCommunicationLinkProperties();
        }
        this.innerProperties().withPartnerServer(partnerServer);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
