// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/** A restorable dropped database. */
@Fluent
public final class RestorableDroppedDatabaseInner extends ProxyResource {
    /*
     * The geo-location where the resource lives
     */
    @JsonProperty(value = "location", access = JsonProperty.Access.WRITE_ONLY)
    private String location;

    /*
     * The properties of a restorable dropped database
     */
    @JsonProperty(value = "properties")
    private RestorableDroppedDatabaseProperties innerProperties;

    /**
     * Get the location property: The geo-location where the resource lives.
     *
     * @return the location value.
     */
    public String location() {
        return this.location;
    }

    /**
     * Get the innerProperties property: The properties of a restorable dropped database.
     *
     * @return the innerProperties value.
     */
    private RestorableDroppedDatabaseProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the databaseName property: The name of the database.
     *
     * @return the databaseName value.
     */
    public String databaseName() {
        return this.innerProperties() == null ? null : this.innerProperties().databaseName();
    }

    /**
     * Get the edition property: The edition of the database.
     *
     * @return the edition value.
     */
    public String edition() {
        return this.innerProperties() == null ? null : this.innerProperties().edition();
    }

    /**
     * Get the maxSizeBytes property: The max size in bytes of the database.
     *
     * @return the maxSizeBytes value.
     */
    public String maxSizeBytes() {
        return this.innerProperties() == null ? null : this.innerProperties().maxSizeBytes();
    }

    /**
     * Get the serviceLevelObjective property: The service level objective name of the database.
     *
     * @return the serviceLevelObjective value.
     */
    public String serviceLevelObjective() {
        return this.innerProperties() == null ? null : this.innerProperties().serviceLevelObjective();
    }

    /**
     * Get the elasticPoolName property: The elastic pool name of the database.
     *
     * @return the elasticPoolName value.
     */
    public String elasticPoolName() {
        return this.innerProperties() == null ? null : this.innerProperties().elasticPoolName();
    }

    /**
     * Get the creationDate property: The creation date of the database (ISO8601 format).
     *
     * @return the creationDate value.
     */
    public OffsetDateTime creationDate() {
        return this.innerProperties() == null ? null : this.innerProperties().creationDate();
    }

    /**
     * Get the deletionDate property: The deletion date of the database (ISO8601 format).
     *
     * @return the deletionDate value.
     */
    public OffsetDateTime deletionDate() {
        return this.innerProperties() == null ? null : this.innerProperties().deletionDate();
    }

    /**
     * Get the earliestRestoreDate property: The earliest restore date of the database (ISO8601 format).
     *
     * @return the earliestRestoreDate value.
     */
    public OffsetDateTime earliestRestoreDate() {
        return this.innerProperties() == null ? null : this.innerProperties().earliestRestoreDate();
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
