// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.resourcemanager.sql.models.ElasticPoolEdition;
import com.azure.resourcemanager.sql.models.TrackedResource;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

/** Represents a recommended elastic pool. */
@Fluent
public final class RecommendedElasticPoolInner extends ProxyResource {
    /*
     * The properties representing the resource.
     */
    @JsonProperty(value = "properties")
    private RecommendedElasticPoolProperties innerProperties;

    /**
     * Get the innerProperties property: The properties representing the resource.
     *
     * @return the innerProperties value.
     */
    private RecommendedElasticPoolProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the databaseEdition property: The edition of the recommended elastic pool. The ElasticPoolEdition enumeration
     * contains all the valid editions.
     *
     * @return the databaseEdition value.
     */
    public ElasticPoolEdition databaseEdition() {
        return this.innerProperties() == null ? null : this.innerProperties().databaseEdition();
    }

    /**
     * Get the dtu property: The DTU for the recommended elastic pool.
     *
     * @return the dtu value.
     */
    public Double dtu() {
        return this.innerProperties() == null ? null : this.innerProperties().dtu();
    }

    /**
     * Set the dtu property: The DTU for the recommended elastic pool.
     *
     * @param dtu the dtu value to set.
     * @return the RecommendedElasticPoolInner object itself.
     */
    public RecommendedElasticPoolInner withDtu(Double dtu) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RecommendedElasticPoolProperties();
        }
        this.innerProperties().withDtu(dtu);
        return this;
    }

    /**
     * Get the databaseDtuMin property: The minimum DTU for the database.
     *
     * @return the databaseDtuMin value.
     */
    public Double databaseDtuMin() {
        return this.innerProperties() == null ? null : this.innerProperties().databaseDtuMin();
    }

    /**
     * Set the databaseDtuMin property: The minimum DTU for the database.
     *
     * @param databaseDtuMin the databaseDtuMin value to set.
     * @return the RecommendedElasticPoolInner object itself.
     */
    public RecommendedElasticPoolInner withDatabaseDtuMin(Double databaseDtuMin) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RecommendedElasticPoolProperties();
        }
        this.innerProperties().withDatabaseDtuMin(databaseDtuMin);
        return this;
    }

    /**
     * Get the databaseDtuMax property: The maximum DTU for the database.
     *
     * @return the databaseDtuMax value.
     */
    public Double databaseDtuMax() {
        return this.innerProperties() == null ? null : this.innerProperties().databaseDtuMax();
    }

    /**
     * Set the databaseDtuMax property: The maximum DTU for the database.
     *
     * @param databaseDtuMax the databaseDtuMax value to set.
     * @return the RecommendedElasticPoolInner object itself.
     */
    public RecommendedElasticPoolInner withDatabaseDtuMax(Double databaseDtuMax) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RecommendedElasticPoolProperties();
        }
        this.innerProperties().withDatabaseDtuMax(databaseDtuMax);
        return this;
    }

    /**
     * Get the storageMB property: Gets storage size in megabytes.
     *
     * @return the storageMB value.
     */
    public Double storageMB() {
        return this.innerProperties() == null ? null : this.innerProperties().storageMB();
    }

    /**
     * Set the storageMB property: Gets storage size in megabytes.
     *
     * @param storageMB the storageMB value to set.
     * @return the RecommendedElasticPoolInner object itself.
     */
    public RecommendedElasticPoolInner withStorageMB(Double storageMB) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RecommendedElasticPoolProperties();
        }
        this.innerProperties().withStorageMB(storageMB);
        return this;
    }

    /**
     * Get the observationPeriodStart property: The observation period start (ISO8601 format).
     *
     * @return the observationPeriodStart value.
     */
    public OffsetDateTime observationPeriodStart() {
        return this.innerProperties() == null ? null : this.innerProperties().observationPeriodStart();
    }

    /**
     * Get the observationPeriodEnd property: The observation period start (ISO8601 format).
     *
     * @return the observationPeriodEnd value.
     */
    public OffsetDateTime observationPeriodEnd() {
        return this.innerProperties() == null ? null : this.innerProperties().observationPeriodEnd();
    }

    /**
     * Get the maxObservedDtu property: Gets maximum observed DTU.
     *
     * @return the maxObservedDtu value.
     */
    public Double maxObservedDtu() {
        return this.innerProperties() == null ? null : this.innerProperties().maxObservedDtu();
    }

    /**
     * Get the maxObservedStorageMB property: Gets maximum observed storage in megabytes.
     *
     * @return the maxObservedStorageMB value.
     */
    public Double maxObservedStorageMB() {
        return this.innerProperties() == null ? null : this.innerProperties().maxObservedStorageMB();
    }

    /**
     * Get the databases property: The list of databases in this pool. Expanded property.
     *
     * @return the databases value.
     */
    public List<TrackedResource> databases() {
        return this.innerProperties() == null ? null : this.innerProperties().databases();
    }

    /**
     * Get the metrics property: The list of databases housed in the server. Expanded property.
     *
     * @return the metrics value.
     */
    public List<RecommendedElasticPoolMetricInner> metrics() {
        return this.innerProperties() == null ? null : this.innerProperties().metrics();
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
