// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.sql.models.VulnerabilityAssessmentRecurringScansProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Properties of a managed instance vulnerability assessment. */
@Fluent
public final class ManagedInstanceVulnerabilityAssessmentProperties {
    /*
     * A blob storage container path to hold the scan results (e.g.
     * https://myStorage.blob.core.windows.net/VaScans/).
     */
    @JsonProperty(value = "storageContainerPath", required = true)
    private String storageContainerPath;

    /*
     * A shared access signature (SAS Key) that has read and write access to
     * the blob container specified in 'storageContainerPath' parameter. If
     * 'storageAccountAccessKey' isn't specified, StorageContainerSasKey is
     * required.
     */
    @JsonProperty(value = "storageContainerSasKey")
    private String storageContainerSasKey;

    /*
     * Specifies the identifier key of the storage account for vulnerability
     * assessment scan results. If 'StorageContainerSasKey' isn't specified,
     * storageAccountAccessKey is required.
     */
    @JsonProperty(value = "storageAccountAccessKey")
    private String storageAccountAccessKey;

    /*
     * The recurring scans settings
     */
    @JsonProperty(value = "recurringScans")
    private VulnerabilityAssessmentRecurringScansProperties recurringScans;

    /**
     * Get the storageContainerPath property: A blob storage container path to hold the scan results (e.g.
     * https://myStorage.blob.core.windows.net/VaScans/).
     *
     * @return the storageContainerPath value.
     */
    public String storageContainerPath() {
        return this.storageContainerPath;
    }

    /**
     * Set the storageContainerPath property: A blob storage container path to hold the scan results (e.g.
     * https://myStorage.blob.core.windows.net/VaScans/).
     *
     * @param storageContainerPath the storageContainerPath value to set.
     * @return the ManagedInstanceVulnerabilityAssessmentProperties object itself.
     */
    public ManagedInstanceVulnerabilityAssessmentProperties withStorageContainerPath(String storageContainerPath) {
        this.storageContainerPath = storageContainerPath;
        return this;
    }

    /**
     * Get the storageContainerSasKey property: A shared access signature (SAS Key) that has read and write access to
     * the blob container specified in 'storageContainerPath' parameter. If 'storageAccountAccessKey' isn't specified,
     * StorageContainerSasKey is required.
     *
     * @return the storageContainerSasKey value.
     */
    public String storageContainerSasKey() {
        return this.storageContainerSasKey;
    }

    /**
     * Set the storageContainerSasKey property: A shared access signature (SAS Key) that has read and write access to
     * the blob container specified in 'storageContainerPath' parameter. If 'storageAccountAccessKey' isn't specified,
     * StorageContainerSasKey is required.
     *
     * @param storageContainerSasKey the storageContainerSasKey value to set.
     * @return the ManagedInstanceVulnerabilityAssessmentProperties object itself.
     */
    public ManagedInstanceVulnerabilityAssessmentProperties withStorageContainerSasKey(String storageContainerSasKey) {
        this.storageContainerSasKey = storageContainerSasKey;
        return this;
    }

    /**
     * Get the storageAccountAccessKey property: Specifies the identifier key of the storage account for vulnerability
     * assessment scan results. If 'StorageContainerSasKey' isn't specified, storageAccountAccessKey is required.
     *
     * @return the storageAccountAccessKey value.
     */
    public String storageAccountAccessKey() {
        return this.storageAccountAccessKey;
    }

    /**
     * Set the storageAccountAccessKey property: Specifies the identifier key of the storage account for vulnerability
     * assessment scan results. If 'StorageContainerSasKey' isn't specified, storageAccountAccessKey is required.
     *
     * @param storageAccountAccessKey the storageAccountAccessKey value to set.
     * @return the ManagedInstanceVulnerabilityAssessmentProperties object itself.
     */
    public ManagedInstanceVulnerabilityAssessmentProperties withStorageAccountAccessKey(
        String storageAccountAccessKey) {
        this.storageAccountAccessKey = storageAccountAccessKey;
        return this;
    }

    /**
     * Get the recurringScans property: The recurring scans settings.
     *
     * @return the recurringScans value.
     */
    public VulnerabilityAssessmentRecurringScansProperties recurringScans() {
        return this.recurringScans;
    }

    /**
     * Set the recurringScans property: The recurring scans settings.
     *
     * @param recurringScans the recurringScans value to set.
     * @return the ManagedInstanceVulnerabilityAssessmentProperties object itself.
     */
    public ManagedInstanceVulnerabilityAssessmentProperties withRecurringScans(
        VulnerabilityAssessmentRecurringScansProperties recurringScans) {
        this.recurringScans = recurringScans;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (storageContainerPath() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property storageContainerPath in model"
                            + " ManagedInstanceVulnerabilityAssessmentProperties"));
        }
        if (recurringScans() != null) {
            recurringScans().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ManagedInstanceVulnerabilityAssessmentProperties.class);
}
