// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.Resource;
import com.azure.resourcemanager.sql.models.ManagedInstanceLicenseType;
import com.azure.resourcemanager.sql.models.ManagedInstanceProxyOverride;
import com.azure.resourcemanager.sql.models.ManagedServerCreateMode;
import com.azure.resourcemanager.sql.models.ResourceIdentity;
import com.azure.resourcemanager.sql.models.Sku;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.Map;

/** An Azure SQL managed instance. */
@Fluent
public final class ManagedInstanceInner extends Resource {
    /*
     * The Azure Active Directory identity of the managed instance.
     */
    @JsonProperty(value = "identity")
    private ResourceIdentity identity;

    /*
     * Managed instance SKU. Allowed values for sku.name: GP_Gen4, GP_Gen5,
     * BC_Gen4, BC_Gen5
     */
    @JsonProperty(value = "sku")
    private Sku sku;

    /*
     * Resource properties.
     */
    @JsonProperty(value = "properties")
    private ManagedInstanceProperties innerProperties;

    /**
     * Get the identity property: The Azure Active Directory identity of the managed instance.
     *
     * @return the identity value.
     */
    public ResourceIdentity identity() {
        return this.identity;
    }

    /**
     * Set the identity property: The Azure Active Directory identity of the managed instance.
     *
     * @param identity the identity value to set.
     * @return the ManagedInstanceInner object itself.
     */
    public ManagedInstanceInner withIdentity(ResourceIdentity identity) {
        this.identity = identity;
        return this;
    }

    /**
     * Get the sku property: Managed instance SKU. Allowed values for sku.name: GP_Gen4, GP_Gen5, BC_Gen4, BC_Gen5.
     *
     * @return the sku value.
     */
    public Sku sku() {
        return this.sku;
    }

    /**
     * Set the sku property: Managed instance SKU. Allowed values for sku.name: GP_Gen4, GP_Gen5, BC_Gen4, BC_Gen5.
     *
     * @param sku the sku value to set.
     * @return the ManagedInstanceInner object itself.
     */
    public ManagedInstanceInner withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    /**
     * Get the innerProperties property: Resource properties.
     *
     * @return the innerProperties value.
     */
    private ManagedInstanceProperties innerProperties() {
        return this.innerProperties;
    }

    /** {@inheritDoc} */
    @Override
    public ManagedInstanceInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public ManagedInstanceInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Get the managedInstanceCreateMode property: Specifies the mode of database creation.
     *
     * <p>Default: Regular instance creation.
     *
     * <p>Restore: Creates an instance by restoring a set of backups to specific point in time. RestorePointInTime and
     * SourceManagedInstanceId must be specified.
     *
     * @return the managedInstanceCreateMode value.
     */
    public ManagedServerCreateMode managedInstanceCreateMode() {
        return this.innerProperties() == null ? null : this.innerProperties().managedInstanceCreateMode();
    }

    /**
     * Set the managedInstanceCreateMode property: Specifies the mode of database creation.
     *
     * <p>Default: Regular instance creation.
     *
     * <p>Restore: Creates an instance by restoring a set of backups to specific point in time. RestorePointInTime and
     * SourceManagedInstanceId must be specified.
     *
     * @param managedInstanceCreateMode the managedInstanceCreateMode value to set.
     * @return the ManagedInstanceInner object itself.
     */
    public ManagedInstanceInner withManagedInstanceCreateMode(ManagedServerCreateMode managedInstanceCreateMode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedInstanceProperties();
        }
        this.innerProperties().withManagedInstanceCreateMode(managedInstanceCreateMode);
        return this;
    }

    /**
     * Get the fullyQualifiedDomainName property: The fully qualified domain name of the managed instance.
     *
     * @return the fullyQualifiedDomainName value.
     */
    public String fullyQualifiedDomainName() {
        return this.innerProperties() == null ? null : this.innerProperties().fullyQualifiedDomainName();
    }

    /**
     * Get the administratorLogin property: Administrator username for the managed instance. Can only be specified when
     * the managed instance is being created (and is required for creation).
     *
     * @return the administratorLogin value.
     */
    public String administratorLogin() {
        return this.innerProperties() == null ? null : this.innerProperties().administratorLogin();
    }

    /**
     * Set the administratorLogin property: Administrator username for the managed instance. Can only be specified when
     * the managed instance is being created (and is required for creation).
     *
     * @param administratorLogin the administratorLogin value to set.
     * @return the ManagedInstanceInner object itself.
     */
    public ManagedInstanceInner withAdministratorLogin(String administratorLogin) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedInstanceProperties();
        }
        this.innerProperties().withAdministratorLogin(administratorLogin);
        return this;
    }

    /**
     * Get the administratorLoginPassword property: The administrator login password (required for managed instance
     * creation).
     *
     * @return the administratorLoginPassword value.
     */
    public String administratorLoginPassword() {
        return this.innerProperties() == null ? null : this.innerProperties().administratorLoginPassword();
    }

    /**
     * Set the administratorLoginPassword property: The administrator login password (required for managed instance
     * creation).
     *
     * @param administratorLoginPassword the administratorLoginPassword value to set.
     * @return the ManagedInstanceInner object itself.
     */
    public ManagedInstanceInner withAdministratorLoginPassword(String administratorLoginPassword) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedInstanceProperties();
        }
        this.innerProperties().withAdministratorLoginPassword(administratorLoginPassword);
        return this;
    }

    /**
     * Get the subnetId property: Subnet resource ID for the managed instance.
     *
     * @return the subnetId value.
     */
    public String subnetId() {
        return this.innerProperties() == null ? null : this.innerProperties().subnetId();
    }

    /**
     * Set the subnetId property: Subnet resource ID for the managed instance.
     *
     * @param subnetId the subnetId value to set.
     * @return the ManagedInstanceInner object itself.
     */
    public ManagedInstanceInner withSubnetId(String subnetId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedInstanceProperties();
        }
        this.innerProperties().withSubnetId(subnetId);
        return this;
    }

    /**
     * Get the state property: The state of the managed instance.
     *
     * @return the state value.
     */
    public String state() {
        return this.innerProperties() == null ? null : this.innerProperties().state();
    }

    /**
     * Get the licenseType property: The license type. Possible values are 'LicenseIncluded' (regular price inclusive of
     * a new SQL license) and 'BasePrice' (discounted AHB price for bringing your own SQL licenses).
     *
     * @return the licenseType value.
     */
    public ManagedInstanceLicenseType licenseType() {
        return this.innerProperties() == null ? null : this.innerProperties().licenseType();
    }

    /**
     * Set the licenseType property: The license type. Possible values are 'LicenseIncluded' (regular price inclusive of
     * a new SQL license) and 'BasePrice' (discounted AHB price for bringing your own SQL licenses).
     *
     * @param licenseType the licenseType value to set.
     * @return the ManagedInstanceInner object itself.
     */
    public ManagedInstanceInner withLicenseType(ManagedInstanceLicenseType licenseType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedInstanceProperties();
        }
        this.innerProperties().withLicenseType(licenseType);
        return this;
    }

    /**
     * Get the vCores property: The number of vCores. Allowed values: 8, 16, 24, 32, 40, 64, 80.
     *
     * @return the vCores value.
     */
    public Integer vCores() {
        return this.innerProperties() == null ? null : this.innerProperties().vCores();
    }

    /**
     * Set the vCores property: The number of vCores. Allowed values: 8, 16, 24, 32, 40, 64, 80.
     *
     * @param vCores the vCores value to set.
     * @return the ManagedInstanceInner object itself.
     */
    public ManagedInstanceInner withVCores(Integer vCores) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedInstanceProperties();
        }
        this.innerProperties().withVCores(vCores);
        return this;
    }

    /**
     * Get the storageSizeInGB property: Storage size in GB. Minimum value: 32. Maximum value: 8192. Increments of 32 GB
     * allowed only.
     *
     * @return the storageSizeInGB value.
     */
    public Integer storageSizeInGB() {
        return this.innerProperties() == null ? null : this.innerProperties().storageSizeInGB();
    }

    /**
     * Set the storageSizeInGB property: Storage size in GB. Minimum value: 32. Maximum value: 8192. Increments of 32 GB
     * allowed only.
     *
     * @param storageSizeInGB the storageSizeInGB value to set.
     * @return the ManagedInstanceInner object itself.
     */
    public ManagedInstanceInner withStorageSizeInGB(Integer storageSizeInGB) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedInstanceProperties();
        }
        this.innerProperties().withStorageSizeInGB(storageSizeInGB);
        return this;
    }

    /**
     * Get the collation property: Collation of the managed instance.
     *
     * @return the collation value.
     */
    public String collation() {
        return this.innerProperties() == null ? null : this.innerProperties().collation();
    }

    /**
     * Set the collation property: Collation of the managed instance.
     *
     * @param collation the collation value to set.
     * @return the ManagedInstanceInner object itself.
     */
    public ManagedInstanceInner withCollation(String collation) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedInstanceProperties();
        }
        this.innerProperties().withCollation(collation);
        return this;
    }

    /**
     * Get the dnsZone property: The Dns Zone that the managed instance is in.
     *
     * @return the dnsZone value.
     */
    public String dnsZone() {
        return this.innerProperties() == null ? null : this.innerProperties().dnsZone();
    }

    /**
     * Get the dnsZonePartner property: The resource id of another managed instance whose DNS zone this managed instance
     * will share after creation.
     *
     * @return the dnsZonePartner value.
     */
    public String dnsZonePartner() {
        return this.innerProperties() == null ? null : this.innerProperties().dnsZonePartner();
    }

    /**
     * Set the dnsZonePartner property: The resource id of another managed instance whose DNS zone this managed instance
     * will share after creation.
     *
     * @param dnsZonePartner the dnsZonePartner value to set.
     * @return the ManagedInstanceInner object itself.
     */
    public ManagedInstanceInner withDnsZonePartner(String dnsZonePartner) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedInstanceProperties();
        }
        this.innerProperties().withDnsZonePartner(dnsZonePartner);
        return this;
    }

    /**
     * Get the publicDataEndpointEnabled property: Whether or not the public data endpoint is enabled.
     *
     * @return the publicDataEndpointEnabled value.
     */
    public Boolean publicDataEndpointEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().publicDataEndpointEnabled();
    }

    /**
     * Set the publicDataEndpointEnabled property: Whether or not the public data endpoint is enabled.
     *
     * @param publicDataEndpointEnabled the publicDataEndpointEnabled value to set.
     * @return the ManagedInstanceInner object itself.
     */
    public ManagedInstanceInner withPublicDataEndpointEnabled(Boolean publicDataEndpointEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedInstanceProperties();
        }
        this.innerProperties().withPublicDataEndpointEnabled(publicDataEndpointEnabled);
        return this;
    }

    /**
     * Get the sourceManagedInstanceId property: The resource identifier of the source managed instance associated with
     * create operation of this instance.
     *
     * @return the sourceManagedInstanceId value.
     */
    public String sourceManagedInstanceId() {
        return this.innerProperties() == null ? null : this.innerProperties().sourceManagedInstanceId();
    }

    /**
     * Set the sourceManagedInstanceId property: The resource identifier of the source managed instance associated with
     * create operation of this instance.
     *
     * @param sourceManagedInstanceId the sourceManagedInstanceId value to set.
     * @return the ManagedInstanceInner object itself.
     */
    public ManagedInstanceInner withSourceManagedInstanceId(String sourceManagedInstanceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedInstanceProperties();
        }
        this.innerProperties().withSourceManagedInstanceId(sourceManagedInstanceId);
        return this;
    }

    /**
     * Get the restorePointInTime property: Specifies the point in time (ISO8601 format) of the source database that
     * will be restored to create the new database.
     *
     * @return the restorePointInTime value.
     */
    public OffsetDateTime restorePointInTime() {
        return this.innerProperties() == null ? null : this.innerProperties().restorePointInTime();
    }

    /**
     * Set the restorePointInTime property: Specifies the point in time (ISO8601 format) of the source database that
     * will be restored to create the new database.
     *
     * @param restorePointInTime the restorePointInTime value to set.
     * @return the ManagedInstanceInner object itself.
     */
    public ManagedInstanceInner withRestorePointInTime(OffsetDateTime restorePointInTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedInstanceProperties();
        }
        this.innerProperties().withRestorePointInTime(restorePointInTime);
        return this;
    }

    /**
     * Get the proxyOverride property: Connection type used for connecting to the instance.
     *
     * @return the proxyOverride value.
     */
    public ManagedInstanceProxyOverride proxyOverride() {
        return this.innerProperties() == null ? null : this.innerProperties().proxyOverride();
    }

    /**
     * Set the proxyOverride property: Connection type used for connecting to the instance.
     *
     * @param proxyOverride the proxyOverride value to set.
     * @return the ManagedInstanceInner object itself.
     */
    public ManagedInstanceInner withProxyOverride(ManagedInstanceProxyOverride proxyOverride) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedInstanceProperties();
        }
        this.innerProperties().withProxyOverride(proxyOverride);
        return this;
    }

    /**
     * Get the timezoneId property: Id of the timezone. Allowed values are timezones supported by Windows. Windows keeps
     * details on supported timezones, including the id, in registry under KEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows
     * NT\CurrentVersion\Time Zones. You can get those registry values via SQL Server by querying SELECT name AS
     * timezone_id FROM sys.time_zone_info. List of Ids can also be obtained by executing
     * [System.TimeZoneInfo]::GetSystemTimeZones() in PowerShell. An example of valid timezone id is "Pacific Standard
     * Time" or "W. Europe Standard Time".
     *
     * @return the timezoneId value.
     */
    public String timezoneId() {
        return this.innerProperties() == null ? null : this.innerProperties().timezoneId();
    }

    /**
     * Set the timezoneId property: Id of the timezone. Allowed values are timezones supported by Windows. Windows keeps
     * details on supported timezones, including the id, in registry under KEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows
     * NT\CurrentVersion\Time Zones. You can get those registry values via SQL Server by querying SELECT name AS
     * timezone_id FROM sys.time_zone_info. List of Ids can also be obtained by executing
     * [System.TimeZoneInfo]::GetSystemTimeZones() in PowerShell. An example of valid timezone id is "Pacific Standard
     * Time" or "W. Europe Standard Time".
     *
     * @param timezoneId the timezoneId value to set.
     * @return the ManagedInstanceInner object itself.
     */
    public ManagedInstanceInner withTimezoneId(String timezoneId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedInstanceProperties();
        }
        this.innerProperties().withTimezoneId(timezoneId);
        return this;
    }

    /**
     * Get the instancePoolId property: The Id of the instance pool this managed server belongs to.
     *
     * @return the instancePoolId value.
     */
    public String instancePoolId() {
        return this.innerProperties() == null ? null : this.innerProperties().instancePoolId();
    }

    /**
     * Set the instancePoolId property: The Id of the instance pool this managed server belongs to.
     *
     * @param instancePoolId the instancePoolId value to set.
     * @return the ManagedInstanceInner object itself.
     */
    public ManagedInstanceInner withInstancePoolId(String instancePoolId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedInstanceProperties();
        }
        this.innerProperties().withInstancePoolId(instancePoolId);
        return this;
    }

    /**
     * Get the minimalTlsVersion property: Minimal TLS version. Allowed values: 'None', '1.0', '1.1', '1.2'.
     *
     * @return the minimalTlsVersion value.
     */
    public String minimalTlsVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().minimalTlsVersion();
    }

    /**
     * Set the minimalTlsVersion property: Minimal TLS version. Allowed values: 'None', '1.0', '1.1', '1.2'.
     *
     * @param minimalTlsVersion the minimalTlsVersion value to set.
     * @return the ManagedInstanceInner object itself.
     */
    public ManagedInstanceInner withMinimalTlsVersion(String minimalTlsVersion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedInstanceProperties();
        }
        this.innerProperties().withMinimalTlsVersion(minimalTlsVersion);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (identity() != null) {
            identity().validate();
        }
        if (sku() != null) {
            sku().validate();
        }
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
