// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.sql.models.ManagedInstanceAdministratorType;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.UUID;

/** The properties of a managed instance administrator. */
@Fluent
public final class ManagedInstanceAdministratorProperties {
    /*
     * Type of the managed instance administrator.
     */
    @JsonProperty(value = "administratorType", required = true)
    private ManagedInstanceAdministratorType administratorType;

    /*
     * Login name of the managed instance administrator.
     */
    @JsonProperty(value = "login", required = true)
    private String login;

    /*
     * SID (object ID) of the managed instance administrator.
     */
    @JsonProperty(value = "sid", required = true)
    private UUID sid;

    /*
     * Tenant ID of the managed instance administrator.
     */
    @JsonProperty(value = "tenantId")
    private UUID tenantId;

    /**
     * Get the administratorType property: Type of the managed instance administrator.
     *
     * @return the administratorType value.
     */
    public ManagedInstanceAdministratorType administratorType() {
        return this.administratorType;
    }

    /**
     * Set the administratorType property: Type of the managed instance administrator.
     *
     * @param administratorType the administratorType value to set.
     * @return the ManagedInstanceAdministratorProperties object itself.
     */
    public ManagedInstanceAdministratorProperties withAdministratorType(
        ManagedInstanceAdministratorType administratorType) {
        this.administratorType = administratorType;
        return this;
    }

    /**
     * Get the login property: Login name of the managed instance administrator.
     *
     * @return the login value.
     */
    public String login() {
        return this.login;
    }

    /**
     * Set the login property: Login name of the managed instance administrator.
     *
     * @param login the login value to set.
     * @return the ManagedInstanceAdministratorProperties object itself.
     */
    public ManagedInstanceAdministratorProperties withLogin(String login) {
        this.login = login;
        return this;
    }

    /**
     * Get the sid property: SID (object ID) of the managed instance administrator.
     *
     * @return the sid value.
     */
    public UUID sid() {
        return this.sid;
    }

    /**
     * Set the sid property: SID (object ID) of the managed instance administrator.
     *
     * @param sid the sid value to set.
     * @return the ManagedInstanceAdministratorProperties object itself.
     */
    public ManagedInstanceAdministratorProperties withSid(UUID sid) {
        this.sid = sid;
        return this;
    }

    /**
     * Get the tenantId property: Tenant ID of the managed instance administrator.
     *
     * @return the tenantId value.
     */
    public UUID tenantId() {
        return this.tenantId;
    }

    /**
     * Set the tenantId property: Tenant ID of the managed instance administrator.
     *
     * @param tenantId the tenantId value to set.
     * @return the ManagedInstanceAdministratorProperties object itself.
     */
    public ManagedInstanceAdministratorProperties withTenantId(UUID tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (administratorType() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property administratorType in model ManagedInstanceAdministratorProperties"));
        }
        if (login() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property login in model ManagedInstanceAdministratorProperties"));
        }
        if (sid() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property sid in model ManagedInstanceAdministratorProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ManagedInstanceAdministratorProperties.class);
}
