// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

/** The managed database's restore details properties. */
@Immutable
public final class ManagedDatabaseRestoreDetailsProperties {
    /*
     * Restore status.
     */
    @JsonProperty(value = "status", access = JsonProperty.Access.WRITE_ONLY)
    private String status;

    /*
     * Current restoring file name.
     */
    @JsonProperty(value = "currentRestoringFileName", access = JsonProperty.Access.WRITE_ONLY)
    private String currentRestoringFileName;

    /*
     * Last restored file name.
     */
    @JsonProperty(value = "lastRestoredFileName", access = JsonProperty.Access.WRITE_ONLY)
    private String lastRestoredFileName;

    /*
     * Last restored file time.
     */
    @JsonProperty(value = "lastRestoredFileTime", access = JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime lastRestoredFileTime;

    /*
     * Percent completed.
     */
    @JsonProperty(value = "percentCompleted", access = JsonProperty.Access.WRITE_ONLY)
    private Double percentCompleted;

    /*
     * List of unrestorable files.
     */
    @JsonProperty(value = "unrestorableFiles", access = JsonProperty.Access.WRITE_ONLY)
    private List<String> unrestorableFiles;

    /*
     * Number of files detected.
     */
    @JsonProperty(value = "numberOfFilesDetected", access = JsonProperty.Access.WRITE_ONLY)
    private Long numberOfFilesDetected;

    /*
     * Last uploaded file name.
     */
    @JsonProperty(value = "lastUploadedFileName", access = JsonProperty.Access.WRITE_ONLY)
    private String lastUploadedFileName;

    /*
     * Last uploaded file time.
     */
    @JsonProperty(value = "lastUploadedFileTime", access = JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime lastUploadedFileTime;

    /*
     * The reason why restore is in Blocked state.
     */
    @JsonProperty(value = "blockReason", access = JsonProperty.Access.WRITE_ONLY)
    private String blockReason;

    /**
     * Get the status property: Restore status.
     *
     * @return the status value.
     */
    public String status() {
        return this.status;
    }

    /**
     * Get the currentRestoringFileName property: Current restoring file name.
     *
     * @return the currentRestoringFileName value.
     */
    public String currentRestoringFileName() {
        return this.currentRestoringFileName;
    }

    /**
     * Get the lastRestoredFileName property: Last restored file name.
     *
     * @return the lastRestoredFileName value.
     */
    public String lastRestoredFileName() {
        return this.lastRestoredFileName;
    }

    /**
     * Get the lastRestoredFileTime property: Last restored file time.
     *
     * @return the lastRestoredFileTime value.
     */
    public OffsetDateTime lastRestoredFileTime() {
        return this.lastRestoredFileTime;
    }

    /**
     * Get the percentCompleted property: Percent completed.
     *
     * @return the percentCompleted value.
     */
    public Double percentCompleted() {
        return this.percentCompleted;
    }

    /**
     * Get the unrestorableFiles property: List of unrestorable files.
     *
     * @return the unrestorableFiles value.
     */
    public List<String> unrestorableFiles() {
        return this.unrestorableFiles;
    }

    /**
     * Get the numberOfFilesDetected property: Number of files detected.
     *
     * @return the numberOfFilesDetected value.
     */
    public Long numberOfFilesDetected() {
        return this.numberOfFilesDetected;
    }

    /**
     * Get the lastUploadedFileName property: Last uploaded file name.
     *
     * @return the lastUploadedFileName value.
     */
    public String lastUploadedFileName() {
        return this.lastUploadedFileName;
    }

    /**
     * Get the lastUploadedFileTime property: Last uploaded file time.
     *
     * @return the lastUploadedFileTime value.
     */
    public OffsetDateTime lastUploadedFileTime() {
        return this.lastUploadedFileTime;
    }

    /**
     * Get the blockReason property: The reason why restore is in Blocked state.
     *
     * @return the blockReason value.
     */
    public String blockReason() {
        return this.blockReason;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
