// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.resourcemanager.sql.models.JobTarget;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** A group of job targets. */
@Fluent
public final class JobTargetGroupInner extends ProxyResource {
    /*
     * Resource properties.
     */
    @JsonProperty(value = "properties")
    private JobTargetGroupProperties innerProperties;

    /**
     * Get the innerProperties property: Resource properties.
     *
     * @return the innerProperties value.
     */
    private JobTargetGroupProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the members property: Members of the target group.
     *
     * @return the members value.
     */
    public List<JobTarget> members() {
        return this.innerProperties() == null ? null : this.innerProperties().members();
    }

    /**
     * Set the members property: Members of the target group.
     *
     * @param members the members value to set.
     * @return the JobTargetGroupInner object itself.
     */
    public JobTargetGroupInner withMembers(List<JobTarget> members) {
        if (this.innerProperties() == null) {
            this.innerProperties = new JobTargetGroupProperties();
        }
        this.innerProperties().withMembers(members);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
