// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.sql.models.AuthenticationType;
import com.azure.resourcemanager.sql.models.ExportRequest;
import com.azure.resourcemanager.sql.models.ImportOperationMode;
import com.azure.resourcemanager.sql.models.StorageKeyType;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Represents the properties for an import operation. */
@Fluent
public final class ImportExtensionProperties extends ExportRequest {
    /*
     * The type of import operation being performed. This is always Import.
     */
    @JsonProperty(value = "operationMode", required = true)
    private ImportOperationMode operationMode;

    /**
     * Get the operationMode property: The type of import operation being performed. This is always Import.
     *
     * @return the operationMode value.
     */
    public ImportOperationMode operationMode() {
        return this.operationMode;
    }

    /**
     * Set the operationMode property: The type of import operation being performed. This is always Import.
     *
     * @param operationMode the operationMode value to set.
     * @return the ImportExtensionProperties object itself.
     */
    public ImportExtensionProperties withOperationMode(ImportOperationMode operationMode) {
        this.operationMode = operationMode;
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public ImportExtensionProperties withStorageKeyType(StorageKeyType storageKeyType) {
        super.withStorageKeyType(storageKeyType);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public ImportExtensionProperties withStorageKey(String storageKey) {
        super.withStorageKey(storageKey);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public ImportExtensionProperties withStorageUri(String storageUri) {
        super.withStorageUri(storageUri);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public ImportExtensionProperties withAdministratorLogin(String administratorLogin) {
        super.withAdministratorLogin(administratorLogin);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public ImportExtensionProperties withAdministratorLoginPassword(String administratorLoginPassword) {
        super.withAdministratorLoginPassword(administratorLoginPassword);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public ImportExtensionProperties withAuthenticationType(AuthenticationType authenticationType) {
        super.withAuthenticationType(authenticationType);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (operationMode() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property operationMode in model ImportExtensionProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ImportExtensionProperties.class);
}
