// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.UUID;

/** Response for Import/Export Get operation. */
@Fluent
public final class ImportExportResponseInner extends ProxyResource {
    /*
     * The import/export operation properties.
     */
    @JsonProperty(value = "properties")
    private ImportExportResponseProperties innerProperties;

    /**
     * Get the innerProperties property: The import/export operation properties.
     *
     * @return the innerProperties value.
     */
    private ImportExportResponseProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the requestType property: The request type of the operation.
     *
     * @return the requestType value.
     */
    public String requestType() {
        return this.innerProperties() == null ? null : this.innerProperties().requestType();
    }

    /**
     * Get the requestId property: The request type of the operation.
     *
     * @return the requestId value.
     */
    public UUID requestId() {
        return this.innerProperties() == null ? null : this.innerProperties().requestId();
    }

    /**
     * Get the serverName property: The name of the server.
     *
     * @return the serverName value.
     */
    public String serverName() {
        return this.innerProperties() == null ? null : this.innerProperties().serverName();
    }

    /**
     * Get the databaseName property: The name of the database.
     *
     * @return the databaseName value.
     */
    public String databaseName() {
        return this.innerProperties() == null ? null : this.innerProperties().databaseName();
    }

    /**
     * Get the status property: The status message returned from the server.
     *
     * @return the status value.
     */
    public String status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    /**
     * Get the lastModifiedTime property: The operation status last modified time.
     *
     * @return the lastModifiedTime value.
     */
    public String lastModifiedTime() {
        return this.innerProperties() == null ? null : this.innerProperties().lastModifiedTime();
    }

    /**
     * Get the queuedTime property: The operation queued time.
     *
     * @return the queuedTime value.
     */
    public String queuedTime() {
        return this.innerProperties() == null ? null : this.innerProperties().queuedTime();
    }

    /**
     * Get the blobUri property: The blob uri.
     *
     * @return the blobUri value.
     */
    public String blobUri() {
        return this.innerProperties() == null ? null : this.innerProperties().blobUri();
    }

    /**
     * Get the errorMessage property: The error message returned from the server.
     *
     * @return the errorMessage value.
     */
    public String errorMessage() {
        return this.innerProperties() == null ? null : this.innerProperties().errorMessage();
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
