// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.sql.models.GeoBackupPolicyState;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The properties of the geo backup policy. */
@Fluent
public final class GeoBackupPolicyProperties {
    /*
     * The state of the geo backup policy.
     */
    @JsonProperty(value = "state", required = true)
    private GeoBackupPolicyState state;

    /*
     * The storage type of the geo backup policy.
     */
    @JsonProperty(value = "storageType", access = JsonProperty.Access.WRITE_ONLY)
    private String storageType;

    /**
     * Get the state property: The state of the geo backup policy.
     *
     * @return the state value.
     */
    public GeoBackupPolicyState state() {
        return this.state;
    }

    /**
     * Set the state property: The state of the geo backup policy.
     *
     * @param state the state value to set.
     * @return the GeoBackupPolicyProperties object itself.
     */
    public GeoBackupPolicyProperties withState(GeoBackupPolicyState state) {
        this.state = state;
        return this;
    }

    /**
     * Get the storageType property: The storage type of the geo backup policy.
     *
     * @return the storageType value.
     */
    public String storageType() {
        return this.storageType;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (state() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException("Missing required property state in model GeoBackupPolicyProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(GeoBackupPolicyProperties.class);
}
