// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.resourcemanager.sql.models.FailoverGroupReadOnlyEndpoint;
import com.azure.resourcemanager.sql.models.FailoverGroupReadWriteEndpoint;
import com.azure.resourcemanager.sql.models.FailoverGroupReplicationRole;
import com.azure.resourcemanager.sql.models.PartnerInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

/** A failover group. */
@Fluent
public final class FailoverGroupInner extends ProxyResource {
    /*
     * Resource location.
     */
    @JsonProperty(value = "location", access = JsonProperty.Access.WRITE_ONLY)
    private String location;

    /*
     * Resource tags.
     */
    @JsonProperty(value = "tags")
    @JsonInclude(value = JsonInclude.Include.NON_NULL, content = JsonInclude.Include.ALWAYS)
    private Map<String, String> tags;

    /*
     * Resource properties.
     */
    @JsonProperty(value = "properties")
    private FailoverGroupProperties innerProperties;

    /**
     * Get the location property: Resource location.
     *
     * @return the location value.
     */
    public String location() {
        return this.location;
    }

    /**
     * Get the tags property: Resource tags.
     *
     * @return the tags value.
     */
    public Map<String, String> tags() {
        return this.tags;
    }

    /**
     * Set the tags property: Resource tags.
     *
     * @param tags the tags value to set.
     * @return the FailoverGroupInner object itself.
     */
    public FailoverGroupInner withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Get the innerProperties property: Resource properties.
     *
     * @return the innerProperties value.
     */
    private FailoverGroupProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the readWriteEndpoint property: Read-write endpoint of the failover group instance.
     *
     * @return the readWriteEndpoint value.
     */
    public FailoverGroupReadWriteEndpoint readWriteEndpoint() {
        return this.innerProperties() == null ? null : this.innerProperties().readWriteEndpoint();
    }

    /**
     * Set the readWriteEndpoint property: Read-write endpoint of the failover group instance.
     *
     * @param readWriteEndpoint the readWriteEndpoint value to set.
     * @return the FailoverGroupInner object itself.
     */
    public FailoverGroupInner withReadWriteEndpoint(FailoverGroupReadWriteEndpoint readWriteEndpoint) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FailoverGroupProperties();
        }
        this.innerProperties().withReadWriteEndpoint(readWriteEndpoint);
        return this;
    }

    /**
     * Get the readOnlyEndpoint property: Read-only endpoint of the failover group instance.
     *
     * @return the readOnlyEndpoint value.
     */
    public FailoverGroupReadOnlyEndpoint readOnlyEndpoint() {
        return this.innerProperties() == null ? null : this.innerProperties().readOnlyEndpoint();
    }

    /**
     * Set the readOnlyEndpoint property: Read-only endpoint of the failover group instance.
     *
     * @param readOnlyEndpoint the readOnlyEndpoint value to set.
     * @return the FailoverGroupInner object itself.
     */
    public FailoverGroupInner withReadOnlyEndpoint(FailoverGroupReadOnlyEndpoint readOnlyEndpoint) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FailoverGroupProperties();
        }
        this.innerProperties().withReadOnlyEndpoint(readOnlyEndpoint);
        return this;
    }

    /**
     * Get the replicationRole property: Local replication role of the failover group instance.
     *
     * @return the replicationRole value.
     */
    public FailoverGroupReplicationRole replicationRole() {
        return this.innerProperties() == null ? null : this.innerProperties().replicationRole();
    }

    /**
     * Get the replicationState property: Replication state of the failover group instance.
     *
     * @return the replicationState value.
     */
    public String replicationState() {
        return this.innerProperties() == null ? null : this.innerProperties().replicationState();
    }

    /**
     * Get the partnerServers property: List of partner server information for the failover group.
     *
     * @return the partnerServers value.
     */
    public List<PartnerInfo> partnerServers() {
        return this.innerProperties() == null ? null : this.innerProperties().partnerServers();
    }

    /**
     * Set the partnerServers property: List of partner server information for the failover group.
     *
     * @param partnerServers the partnerServers value to set.
     * @return the FailoverGroupInner object itself.
     */
    public FailoverGroupInner withPartnerServers(List<PartnerInfo> partnerServers) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FailoverGroupProperties();
        }
        this.innerProperties().withPartnerServers(partnerServers);
        return this;
    }

    /**
     * Get the databases property: List of databases in the failover group.
     *
     * @return the databases value.
     */
    public List<String> databases() {
        return this.innerProperties() == null ? null : this.innerProperties().databases();
    }

    /**
     * Set the databases property: List of databases in the failover group.
     *
     * @param databases the databases value to set.
     * @return the FailoverGroupInner object itself.
     */
    public FailoverGroupInner withDatabases(List<String> databases) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FailoverGroupProperties();
        }
        this.innerProperties().withDatabases(databases);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
