// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.UUID;

/** Represents the activity on an elastic pool. */
@Fluent
public final class ElasticPoolDatabaseActivityInner extends ProxyResource {
    /*
     * The geo-location where the resource lives
     */
    @JsonProperty(value = "location")
    private String location;

    /*
     * The properties representing the resource.
     */
    @JsonProperty(value = "properties")
    private ElasticPoolDatabaseActivityProperties innerProperties;

    /**
     * Get the location property: The geo-location where the resource lives.
     *
     * @return the location value.
     */
    public String location() {
        return this.location;
    }

    /**
     * Set the location property: The geo-location where the resource lives.
     *
     * @param location the location value to set.
     * @return the ElasticPoolDatabaseActivityInner object itself.
     */
    public ElasticPoolDatabaseActivityInner withLocation(String location) {
        this.location = location;
        return this;
    }

    /**
     * Get the innerProperties property: The properties representing the resource.
     *
     * @return the innerProperties value.
     */
    private ElasticPoolDatabaseActivityProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the databaseName property: The database name.
     *
     * @return the databaseName value.
     */
    public String databaseName() {
        return this.innerProperties() == null ? null : this.innerProperties().databaseName();
    }

    /**
     * Get the endTime property: The time the operation finished (ISO8601 format).
     *
     * @return the endTime value.
     */
    public OffsetDateTime endTime() {
        return this.innerProperties() == null ? null : this.innerProperties().endTime();
    }

    /**
     * Get the errorCode property: The error code if available.
     *
     * @return the errorCode value.
     */
    public Integer errorCode() {
        return this.innerProperties() == null ? null : this.innerProperties().errorCode();
    }

    /**
     * Get the errorMessage property: The error message if available.
     *
     * @return the errorMessage value.
     */
    public String errorMessage() {
        return this.innerProperties() == null ? null : this.innerProperties().errorMessage();
    }

    /**
     * Get the errorSeverity property: The error severity if available.
     *
     * @return the errorSeverity value.
     */
    public Integer errorSeverity() {
        return this.innerProperties() == null ? null : this.innerProperties().errorSeverity();
    }

    /**
     * Get the operation property: The operation name.
     *
     * @return the operation value.
     */
    public String operation() {
        return this.innerProperties() == null ? null : this.innerProperties().operation();
    }

    /**
     * Get the operationId property: The unique operation ID.
     *
     * @return the operationId value.
     */
    public UUID operationId() {
        return this.innerProperties() == null ? null : this.innerProperties().operationId();
    }

    /**
     * Get the percentComplete property: The percentage complete if available.
     *
     * @return the percentComplete value.
     */
    public Integer percentComplete() {
        return this.innerProperties() == null ? null : this.innerProperties().percentComplete();
    }

    /**
     * Get the requestedElasticPoolName property: The name for the elastic pool the database is moving into if
     * available.
     *
     * @return the requestedElasticPoolName value.
     */
    public String requestedElasticPoolName() {
        return this.innerProperties() == null ? null : this.innerProperties().requestedElasticPoolName();
    }

    /**
     * Get the currentElasticPoolName property: The name of the current elastic pool the database is in if available.
     *
     * @return the currentElasticPoolName value.
     */
    public String currentElasticPoolName() {
        return this.innerProperties() == null ? null : this.innerProperties().currentElasticPoolName();
    }

    /**
     * Get the currentServiceObjective property: The name of the current service objective if available.
     *
     * @return the currentServiceObjective value.
     */
    public String currentServiceObjective() {
        return this.innerProperties() == null ? null : this.innerProperties().currentServiceObjective();
    }

    /**
     * Get the requestedServiceObjective property: The name of the requested service objective if available.
     *
     * @return the requestedServiceObjective value.
     */
    public String requestedServiceObjective() {
        return this.innerProperties() == null ? null : this.innerProperties().requestedServiceObjective();
    }

    /**
     * Get the serverName property: The name of the server the elastic pool is in.
     *
     * @return the serverName value.
     */
    public String serverName() {
        return this.innerProperties() == null ? null : this.innerProperties().serverName();
    }

    /**
     * Get the startTime property: The time the operation started (ISO8601 format).
     *
     * @return the startTime value.
     */
    public OffsetDateTime startTime() {
        return this.innerProperties() == null ? null : this.innerProperties().startTime();
    }

    /**
     * Get the state property: The current state of the operation.
     *
     * @return the state value.
     */
    public String state() {
        return this.innerProperties() == null ? null : this.innerProperties().state();
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
