// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.UUID;

/** Represents the activity on an elastic pool. */
@Fluent
public final class ElasticPoolActivityInner extends ProxyResource {
    /*
     * The geo-location where the resource lives
     */
    @JsonProperty(value = "location")
    private String location;

    /*
     * The properties representing the resource.
     */
    @JsonProperty(value = "properties")
    private ElasticPoolActivityProperties innerProperties;

    /**
     * Get the location property: The geo-location where the resource lives.
     *
     * @return the location value.
     */
    public String location() {
        return this.location;
    }

    /**
     * Set the location property: The geo-location where the resource lives.
     *
     * @param location the location value to set.
     * @return the ElasticPoolActivityInner object itself.
     */
    public ElasticPoolActivityInner withLocation(String location) {
        this.location = location;
        return this;
    }

    /**
     * Get the innerProperties property: The properties representing the resource.
     *
     * @return the innerProperties value.
     */
    private ElasticPoolActivityProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the endTime property: The time the operation finished (ISO8601 format).
     *
     * @return the endTime value.
     */
    public OffsetDateTime endTime() {
        return this.innerProperties() == null ? null : this.innerProperties().endTime();
    }

    /**
     * Get the errorCode property: The error code if available.
     *
     * @return the errorCode value.
     */
    public Integer errorCode() {
        return this.innerProperties() == null ? null : this.innerProperties().errorCode();
    }

    /**
     * Get the errorMessage property: The error message if available.
     *
     * @return the errorMessage value.
     */
    public String errorMessage() {
        return this.innerProperties() == null ? null : this.innerProperties().errorMessage();
    }

    /**
     * Get the errorSeverity property: The error severity if available.
     *
     * @return the errorSeverity value.
     */
    public Integer errorSeverity() {
        return this.innerProperties() == null ? null : this.innerProperties().errorSeverity();
    }

    /**
     * Get the operation property: The operation name.
     *
     * @return the operation value.
     */
    public String operation() {
        return this.innerProperties() == null ? null : this.innerProperties().operation();
    }

    /**
     * Get the operationId property: The unique operation ID.
     *
     * @return the operationId value.
     */
    public UUID operationId() {
        return this.innerProperties() == null ? null : this.innerProperties().operationId();
    }

    /**
     * Get the percentComplete property: The percentage complete if available.
     *
     * @return the percentComplete value.
     */
    public Integer percentComplete() {
        return this.innerProperties() == null ? null : this.innerProperties().percentComplete();
    }

    /**
     * Get the requestedDatabaseDtuMax property: The requested max DTU per database if available.
     *
     * @return the requestedDatabaseDtuMax value.
     */
    public Integer requestedDatabaseDtuMax() {
        return this.innerProperties() == null ? null : this.innerProperties().requestedDatabaseDtuMax();
    }

    /**
     * Get the requestedDatabaseDtuMin property: The requested min DTU per database if available.
     *
     * @return the requestedDatabaseDtuMin value.
     */
    public Integer requestedDatabaseDtuMin() {
        return this.innerProperties() == null ? null : this.innerProperties().requestedDatabaseDtuMin();
    }

    /**
     * Get the requestedDtu property: The requested DTU for the pool if available.
     *
     * @return the requestedDtu value.
     */
    public Integer requestedDtu() {
        return this.innerProperties() == null ? null : this.innerProperties().requestedDtu();
    }

    /**
     * Get the requestedElasticPoolName property: The requested name for the elastic pool if available.
     *
     * @return the requestedElasticPoolName value.
     */
    public String requestedElasticPoolName() {
        return this.innerProperties() == null ? null : this.innerProperties().requestedElasticPoolName();
    }

    /**
     * Get the requestedStorageLimitInGB property: The requested storage limit for the pool in GB if available.
     *
     * @return the requestedStorageLimitInGB value.
     */
    public Long requestedStorageLimitInGB() {
        return this.innerProperties() == null ? null : this.innerProperties().requestedStorageLimitInGB();
    }

    /**
     * Get the elasticPoolName property: The name of the elastic pool.
     *
     * @return the elasticPoolName value.
     */
    public String elasticPoolName() {
        return this.innerProperties() == null ? null : this.innerProperties().elasticPoolName();
    }

    /**
     * Get the serverName property: The name of the server the elastic pool is in.
     *
     * @return the serverName value.
     */
    public String serverName() {
        return this.innerProperties() == null ? null : this.innerProperties().serverName();
    }

    /**
     * Get the startTime property: The time the operation started (ISO8601 format).
     *
     * @return the startTime value.
     */
    public OffsetDateTime startTime() {
        return this.innerProperties() == null ? null : this.innerProperties().startTime();
    }

    /**
     * Get the state property: The current state of the operation.
     *
     * @return the state value.
     */
    public String state() {
        return this.innerProperties() == null ? null : this.innerProperties().state();
    }

    /**
     * Get the requestedStorageLimitInMB property: The requested storage limit in MB.
     *
     * @return the requestedStorageLimitInMB value.
     */
    public Integer requestedStorageLimitInMB() {
        return this.innerProperties() == null ? null : this.innerProperties().requestedStorageLimitInMB();
    }

    /**
     * Get the requestedDatabaseDtuGuarantee property: The requested per database DTU guarantee.
     *
     * @return the requestedDatabaseDtuGuarantee value.
     */
    public Integer requestedDatabaseDtuGuarantee() {
        return this.innerProperties() == null ? null : this.innerProperties().requestedDatabaseDtuGuarantee();
    }

    /**
     * Get the requestedDatabaseDtuCap property: The requested per database DTU cap.
     *
     * @return the requestedDatabaseDtuCap value.
     */
    public Integer requestedDatabaseDtuCap() {
        return this.innerProperties() == null ? null : this.innerProperties().requestedDatabaseDtuCap();
    }

    /**
     * Get the requestedDtuGuarantee property: The requested DTU guarantee.
     *
     * @return the requestedDtuGuarantee value.
     */
    public Integer requestedDtuGuarantee() {
        return this.innerProperties() == null ? null : this.innerProperties().requestedDtuGuarantee();
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
