// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.fasterxml.jackson.annotation.JsonProperty;

/** A database Vulnerability Assessment scan export resource. */
@Fluent
public final class DatabaseVulnerabilityAssessmentScansExportInner extends ProxyResource {
    /*
     * Resource properties.
     */
    @JsonProperty(value = "properties")
    private DatabaseVulnerabilityAssessmentScanExportProperties innerProperties;

    /**
     * Get the innerProperties property: Resource properties.
     *
     * @return the innerProperties value.
     */
    private DatabaseVulnerabilityAssessmentScanExportProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the exportedReportLocation property: Location of the exported report (e.g.
     * https://myStorage.blob.core.windows.net/VaScans/scans/serverName/databaseName/scan_scanId.xlsx).
     *
     * @return the exportedReportLocation value.
     */
    public String exportedReportLocation() {
        return this.innerProperties() == null ? null : this.innerProperties().exportedReportLocation();
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
