// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.resourcemanager.sql.models.DatabaseVulnerabilityAssessmentRuleBaselineItem;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** A database vulnerability assessment rule baseline. */
@Fluent
public final class DatabaseVulnerabilityAssessmentRuleBaselineInner extends ProxyResource {
    /*
     * Resource properties.
     */
    @JsonProperty(value = "properties")
    private DatabaseVulnerabilityAssessmentRuleBaselineProperties innerProperties;

    /**
     * Get the innerProperties property: Resource properties.
     *
     * @return the innerProperties value.
     */
    private DatabaseVulnerabilityAssessmentRuleBaselineProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the baselineResults property: The rule baseline result.
     *
     * @return the baselineResults value.
     */
    public List<DatabaseVulnerabilityAssessmentRuleBaselineItem> baselineResults() {
        return this.innerProperties() == null ? null : this.innerProperties().baselineResults();
    }

    /**
     * Set the baselineResults property: The rule baseline result.
     *
     * @param baselineResults the baselineResults value to set.
     * @return the DatabaseVulnerabilityAssessmentRuleBaselineInner object itself.
     */
    public DatabaseVulnerabilityAssessmentRuleBaselineInner withBaselineResults(
        List<DatabaseVulnerabilityAssessmentRuleBaselineItem> baselineResults) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseVulnerabilityAssessmentRuleBaselineProperties();
        }
        this.innerProperties().withBaselineResults(baselineResults);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
