// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.sql.models.SecurityAlertPolicyEmailAccountAdmins;
import com.azure.resourcemanager.sql.models.SecurityAlertPolicyState;
import com.azure.resourcemanager.sql.models.SecurityAlertPolicyUseServerDefault;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Properties for a database Threat Detection policy. */
@Fluent
public final class DatabaseSecurityAlertPolicyProperties {
    /*
     * Specifies the state of the policy. If state is Enabled, storageEndpoint
     * and storageAccountAccessKey are required.
     */
    @JsonProperty(value = "state", required = true)
    private SecurityAlertPolicyState state;

    /*
     * Specifies the semicolon-separated list of alerts that are disabled, or
     * empty string to disable no alerts. Possible values: Sql_Injection;
     * Sql_Injection_Vulnerability; Access_Anomaly; Data_Exfiltration;
     * Unsafe_Action.
     */
    @JsonProperty(value = "disabledAlerts")
    private String disabledAlerts;

    /*
     * Specifies the semicolon-separated list of e-mail addresses to which the
     * alert is sent.
     */
    @JsonProperty(value = "emailAddresses")
    private String emailAddresses;

    /*
     * Specifies that the alert is sent to the account administrators.
     */
    @JsonProperty(value = "emailAccountAdmins")
    private SecurityAlertPolicyEmailAccountAdmins emailAccountAdmins;

    /*
     * Specifies the blob storage endpoint (e.g.
     * https://MyAccount.blob.core.windows.net). This blob storage will hold
     * all Threat Detection audit logs. If state is Enabled, storageEndpoint is
     * required.
     */
    @JsonProperty(value = "storageEndpoint")
    private String storageEndpoint;

    /*
     * Specifies the identifier key of the Threat Detection audit storage
     * account. If state is Enabled, storageAccountAccessKey is required.
     */
    @JsonProperty(value = "storageAccountAccessKey")
    private String storageAccountAccessKey;

    /*
     * Specifies the number of days to keep in the Threat Detection audit logs.
     */
    @JsonProperty(value = "retentionDays")
    private Integer retentionDays;

    /*
     * Specifies whether to use the default server policy.
     */
    @JsonProperty(value = "useServerDefault")
    private SecurityAlertPolicyUseServerDefault useServerDefault;

    /**
     * Get the state property: Specifies the state of the policy. If state is Enabled, storageEndpoint and
     * storageAccountAccessKey are required.
     *
     * @return the state value.
     */
    public SecurityAlertPolicyState state() {
        return this.state;
    }

    /**
     * Set the state property: Specifies the state of the policy. If state is Enabled, storageEndpoint and
     * storageAccountAccessKey are required.
     *
     * @param state the state value to set.
     * @return the DatabaseSecurityAlertPolicyProperties object itself.
     */
    public DatabaseSecurityAlertPolicyProperties withState(SecurityAlertPolicyState state) {
        this.state = state;
        return this;
    }

    /**
     * Get the disabledAlerts property: Specifies the semicolon-separated list of alerts that are disabled, or empty
     * string to disable no alerts. Possible values: Sql_Injection; Sql_Injection_Vulnerability; Access_Anomaly;
     * Data_Exfiltration; Unsafe_Action.
     *
     * @return the disabledAlerts value.
     */
    public String disabledAlerts() {
        return this.disabledAlerts;
    }

    /**
     * Set the disabledAlerts property: Specifies the semicolon-separated list of alerts that are disabled, or empty
     * string to disable no alerts. Possible values: Sql_Injection; Sql_Injection_Vulnerability; Access_Anomaly;
     * Data_Exfiltration; Unsafe_Action.
     *
     * @param disabledAlerts the disabledAlerts value to set.
     * @return the DatabaseSecurityAlertPolicyProperties object itself.
     */
    public DatabaseSecurityAlertPolicyProperties withDisabledAlerts(String disabledAlerts) {
        this.disabledAlerts = disabledAlerts;
        return this;
    }

    /**
     * Get the emailAddresses property: Specifies the semicolon-separated list of e-mail addresses to which the alert is
     * sent.
     *
     * @return the emailAddresses value.
     */
    public String emailAddresses() {
        return this.emailAddresses;
    }

    /**
     * Set the emailAddresses property: Specifies the semicolon-separated list of e-mail addresses to which the alert is
     * sent.
     *
     * @param emailAddresses the emailAddresses value to set.
     * @return the DatabaseSecurityAlertPolicyProperties object itself.
     */
    public DatabaseSecurityAlertPolicyProperties withEmailAddresses(String emailAddresses) {
        this.emailAddresses = emailAddresses;
        return this;
    }

    /**
     * Get the emailAccountAdmins property: Specifies that the alert is sent to the account administrators.
     *
     * @return the emailAccountAdmins value.
     */
    public SecurityAlertPolicyEmailAccountAdmins emailAccountAdmins() {
        return this.emailAccountAdmins;
    }

    /**
     * Set the emailAccountAdmins property: Specifies that the alert is sent to the account administrators.
     *
     * @param emailAccountAdmins the emailAccountAdmins value to set.
     * @return the DatabaseSecurityAlertPolicyProperties object itself.
     */
    public DatabaseSecurityAlertPolicyProperties withEmailAccountAdmins(
        SecurityAlertPolicyEmailAccountAdmins emailAccountAdmins) {
        this.emailAccountAdmins = emailAccountAdmins;
        return this;
    }

    /**
     * Get the storageEndpoint property: Specifies the blob storage endpoint (e.g.
     * https://MyAccount.blob.core.windows.net). This blob storage will hold all Threat Detection audit logs. If state
     * is Enabled, storageEndpoint is required.
     *
     * @return the storageEndpoint value.
     */
    public String storageEndpoint() {
        return this.storageEndpoint;
    }

    /**
     * Set the storageEndpoint property: Specifies the blob storage endpoint (e.g.
     * https://MyAccount.blob.core.windows.net). This blob storage will hold all Threat Detection audit logs. If state
     * is Enabled, storageEndpoint is required.
     *
     * @param storageEndpoint the storageEndpoint value to set.
     * @return the DatabaseSecurityAlertPolicyProperties object itself.
     */
    public DatabaseSecurityAlertPolicyProperties withStorageEndpoint(String storageEndpoint) {
        this.storageEndpoint = storageEndpoint;
        return this;
    }

    /**
     * Get the storageAccountAccessKey property: Specifies the identifier key of the Threat Detection audit storage
     * account. If state is Enabled, storageAccountAccessKey is required.
     *
     * @return the storageAccountAccessKey value.
     */
    public String storageAccountAccessKey() {
        return this.storageAccountAccessKey;
    }

    /**
     * Set the storageAccountAccessKey property: Specifies the identifier key of the Threat Detection audit storage
     * account. If state is Enabled, storageAccountAccessKey is required.
     *
     * @param storageAccountAccessKey the storageAccountAccessKey value to set.
     * @return the DatabaseSecurityAlertPolicyProperties object itself.
     */
    public DatabaseSecurityAlertPolicyProperties withStorageAccountAccessKey(String storageAccountAccessKey) {
        this.storageAccountAccessKey = storageAccountAccessKey;
        return this;
    }

    /**
     * Get the retentionDays property: Specifies the number of days to keep in the Threat Detection audit logs.
     *
     * @return the retentionDays value.
     */
    public Integer retentionDays() {
        return this.retentionDays;
    }

    /**
     * Set the retentionDays property: Specifies the number of days to keep in the Threat Detection audit logs.
     *
     * @param retentionDays the retentionDays value to set.
     * @return the DatabaseSecurityAlertPolicyProperties object itself.
     */
    public DatabaseSecurityAlertPolicyProperties withRetentionDays(Integer retentionDays) {
        this.retentionDays = retentionDays;
        return this;
    }

    /**
     * Get the useServerDefault property: Specifies whether to use the default server policy.
     *
     * @return the useServerDefault value.
     */
    public SecurityAlertPolicyUseServerDefault useServerDefault() {
        return this.useServerDefault;
    }

    /**
     * Set the useServerDefault property: Specifies whether to use the default server policy.
     *
     * @param useServerDefault the useServerDefault value to set.
     * @return the DatabaseSecurityAlertPolicyProperties object itself.
     */
    public DatabaseSecurityAlertPolicyProperties withUseServerDefault(
        SecurityAlertPolicyUseServerDefault useServerDefault) {
        this.useServerDefault = useServerDefault;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (state() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property state in model DatabaseSecurityAlertPolicyProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(DatabaseSecurityAlertPolicyProperties.class);
}
