// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.resourcemanager.sql.models.SecurityAlertPolicyEmailAccountAdmins;
import com.azure.resourcemanager.sql.models.SecurityAlertPolicyState;
import com.azure.resourcemanager.sql.models.SecurityAlertPolicyUseServerDefault;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Contains information about a database Threat Detection policy. */
@Fluent
public final class DatabaseSecurityAlertPolicyInner extends ProxyResource {
    /*
     * The geo-location where the resource lives
     */
    @JsonProperty(value = "location")
    private String location;

    /*
     * Resource kind.
     */
    @JsonProperty(value = "kind", access = JsonProperty.Access.WRITE_ONLY)
    private String kind;

    /*
     * Properties of the security alert policy.
     */
    @JsonProperty(value = "properties")
    private DatabaseSecurityAlertPolicyProperties innerProperties;

    /**
     * Get the location property: The geo-location where the resource lives.
     *
     * @return the location value.
     */
    public String location() {
        return this.location;
    }

    /**
     * Set the location property: The geo-location where the resource lives.
     *
     * @param location the location value to set.
     * @return the DatabaseSecurityAlertPolicyInner object itself.
     */
    public DatabaseSecurityAlertPolicyInner withLocation(String location) {
        this.location = location;
        return this;
    }

    /**
     * Get the kind property: Resource kind.
     *
     * @return the kind value.
     */
    public String kind() {
        return this.kind;
    }

    /**
     * Get the innerProperties property: Properties of the security alert policy.
     *
     * @return the innerProperties value.
     */
    private DatabaseSecurityAlertPolicyProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the state property: Specifies the state of the policy. If state is Enabled, storageEndpoint and
     * storageAccountAccessKey are required.
     *
     * @return the state value.
     */
    public SecurityAlertPolicyState state() {
        return this.innerProperties() == null ? null : this.innerProperties().state();
    }

    /**
     * Set the state property: Specifies the state of the policy. If state is Enabled, storageEndpoint and
     * storageAccountAccessKey are required.
     *
     * @param state the state value to set.
     * @return the DatabaseSecurityAlertPolicyInner object itself.
     */
    public DatabaseSecurityAlertPolicyInner withState(SecurityAlertPolicyState state) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseSecurityAlertPolicyProperties();
        }
        this.innerProperties().withState(state);
        return this;
    }

    /**
     * Get the disabledAlerts property: Specifies the semicolon-separated list of alerts that are disabled, or empty
     * string to disable no alerts. Possible values: Sql_Injection; Sql_Injection_Vulnerability; Access_Anomaly;
     * Data_Exfiltration; Unsafe_Action.
     *
     * @return the disabledAlerts value.
     */
    public String disabledAlerts() {
        return this.innerProperties() == null ? null : this.innerProperties().disabledAlerts();
    }

    /**
     * Set the disabledAlerts property: Specifies the semicolon-separated list of alerts that are disabled, or empty
     * string to disable no alerts. Possible values: Sql_Injection; Sql_Injection_Vulnerability; Access_Anomaly;
     * Data_Exfiltration; Unsafe_Action.
     *
     * @param disabledAlerts the disabledAlerts value to set.
     * @return the DatabaseSecurityAlertPolicyInner object itself.
     */
    public DatabaseSecurityAlertPolicyInner withDisabledAlerts(String disabledAlerts) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseSecurityAlertPolicyProperties();
        }
        this.innerProperties().withDisabledAlerts(disabledAlerts);
        return this;
    }

    /**
     * Get the emailAddresses property: Specifies the semicolon-separated list of e-mail addresses to which the alert is
     * sent.
     *
     * @return the emailAddresses value.
     */
    public String emailAddresses() {
        return this.innerProperties() == null ? null : this.innerProperties().emailAddresses();
    }

    /**
     * Set the emailAddresses property: Specifies the semicolon-separated list of e-mail addresses to which the alert is
     * sent.
     *
     * @param emailAddresses the emailAddresses value to set.
     * @return the DatabaseSecurityAlertPolicyInner object itself.
     */
    public DatabaseSecurityAlertPolicyInner withEmailAddresses(String emailAddresses) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseSecurityAlertPolicyProperties();
        }
        this.innerProperties().withEmailAddresses(emailAddresses);
        return this;
    }

    /**
     * Get the emailAccountAdmins property: Specifies that the alert is sent to the account administrators.
     *
     * @return the emailAccountAdmins value.
     */
    public SecurityAlertPolicyEmailAccountAdmins emailAccountAdmins() {
        return this.innerProperties() == null ? null : this.innerProperties().emailAccountAdmins();
    }

    /**
     * Set the emailAccountAdmins property: Specifies that the alert is sent to the account administrators.
     *
     * @param emailAccountAdmins the emailAccountAdmins value to set.
     * @return the DatabaseSecurityAlertPolicyInner object itself.
     */
    public DatabaseSecurityAlertPolicyInner withEmailAccountAdmins(
        SecurityAlertPolicyEmailAccountAdmins emailAccountAdmins) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseSecurityAlertPolicyProperties();
        }
        this.innerProperties().withEmailAccountAdmins(emailAccountAdmins);
        return this;
    }

    /**
     * Get the storageEndpoint property: Specifies the blob storage endpoint (e.g.
     * https://MyAccount.blob.core.windows.net). This blob storage will hold all Threat Detection audit logs. If state
     * is Enabled, storageEndpoint is required.
     *
     * @return the storageEndpoint value.
     */
    public String storageEndpoint() {
        return this.innerProperties() == null ? null : this.innerProperties().storageEndpoint();
    }

    /**
     * Set the storageEndpoint property: Specifies the blob storage endpoint (e.g.
     * https://MyAccount.blob.core.windows.net). This blob storage will hold all Threat Detection audit logs. If state
     * is Enabled, storageEndpoint is required.
     *
     * @param storageEndpoint the storageEndpoint value to set.
     * @return the DatabaseSecurityAlertPolicyInner object itself.
     */
    public DatabaseSecurityAlertPolicyInner withStorageEndpoint(String storageEndpoint) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseSecurityAlertPolicyProperties();
        }
        this.innerProperties().withStorageEndpoint(storageEndpoint);
        return this;
    }

    /**
     * Get the storageAccountAccessKey property: Specifies the identifier key of the Threat Detection audit storage
     * account. If state is Enabled, storageAccountAccessKey is required.
     *
     * @return the storageAccountAccessKey value.
     */
    public String storageAccountAccessKey() {
        return this.innerProperties() == null ? null : this.innerProperties().storageAccountAccessKey();
    }

    /**
     * Set the storageAccountAccessKey property: Specifies the identifier key of the Threat Detection audit storage
     * account. If state is Enabled, storageAccountAccessKey is required.
     *
     * @param storageAccountAccessKey the storageAccountAccessKey value to set.
     * @return the DatabaseSecurityAlertPolicyInner object itself.
     */
    public DatabaseSecurityAlertPolicyInner withStorageAccountAccessKey(String storageAccountAccessKey) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseSecurityAlertPolicyProperties();
        }
        this.innerProperties().withStorageAccountAccessKey(storageAccountAccessKey);
        return this;
    }

    /**
     * Get the retentionDays property: Specifies the number of days to keep in the Threat Detection audit logs.
     *
     * @return the retentionDays value.
     */
    public Integer retentionDays() {
        return this.innerProperties() == null ? null : this.innerProperties().retentionDays();
    }

    /**
     * Set the retentionDays property: Specifies the number of days to keep in the Threat Detection audit logs.
     *
     * @param retentionDays the retentionDays value to set.
     * @return the DatabaseSecurityAlertPolicyInner object itself.
     */
    public DatabaseSecurityAlertPolicyInner withRetentionDays(Integer retentionDays) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseSecurityAlertPolicyProperties();
        }
        this.innerProperties().withRetentionDays(retentionDays);
        return this;
    }

    /**
     * Get the useServerDefault property: Specifies whether to use the default server policy.
     *
     * @return the useServerDefault value.
     */
    public SecurityAlertPolicyUseServerDefault useServerDefault() {
        return this.innerProperties() == null ? null : this.innerProperties().useServerDefault();
    }

    /**
     * Set the useServerDefault property: Specifies whether to use the default server policy.
     *
     * @param useServerDefault the useServerDefault value to set.
     * @return the DatabaseSecurityAlertPolicyInner object itself.
     */
    public DatabaseSecurityAlertPolicyInner withUseServerDefault(SecurityAlertPolicyUseServerDefault useServerDefault) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseSecurityAlertPolicyProperties();
        }
        this.innerProperties().withUseServerDefault(useServerDefault);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
