// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.sql.fluent.models.ManagedInstanceVulnerabilityAssessmentInner;
import com.azure.resourcemanager.sql.models.VulnerabilityAssessmentName;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in
 * ManagedInstanceVulnerabilityAssessmentsClient.
 */
public interface ManagedInstanceVulnerabilityAssessmentsClient {
    /**
     * Gets the managed instance's vulnerability assessment.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance for which the vulnerability assessment is defined.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the managed instance's vulnerability assessment along with {@link Response} on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<ManagedInstanceVulnerabilityAssessmentInner>> getWithResponseAsync(
        String resourceGroupName, String managedInstanceName, VulnerabilityAssessmentName vulnerabilityAssessmentName);

    /**
     * Gets the managed instance's vulnerability assessment.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance for which the vulnerability assessment is defined.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the managed instance's vulnerability assessment on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ManagedInstanceVulnerabilityAssessmentInner> getAsync(
        String resourceGroupName, String managedInstanceName, VulnerabilityAssessmentName vulnerabilityAssessmentName);

    /**
     * Gets the managed instance's vulnerability assessment.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance for which the vulnerability assessment is defined.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the managed instance's vulnerability assessment.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ManagedInstanceVulnerabilityAssessmentInner get(
        String resourceGroupName, String managedInstanceName, VulnerabilityAssessmentName vulnerabilityAssessmentName);

    /**
     * Gets the managed instance's vulnerability assessment.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance for which the vulnerability assessment is defined.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the managed instance's vulnerability assessment along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ManagedInstanceVulnerabilityAssessmentInner> getWithResponse(
        String resourceGroupName,
        String managedInstanceName,
        VulnerabilityAssessmentName vulnerabilityAssessmentName,
        Context context);

    /**
     * Creates or updates the managed instance's vulnerability assessment.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance for which the vulnerability assessment is defined.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @param parameters The requested resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a managed instance vulnerability assessment along with {@link Response} on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<ManagedInstanceVulnerabilityAssessmentInner>> createOrUpdateWithResponseAsync(
        String resourceGroupName,
        String managedInstanceName,
        VulnerabilityAssessmentName vulnerabilityAssessmentName,
        ManagedInstanceVulnerabilityAssessmentInner parameters);

    /**
     * Creates or updates the managed instance's vulnerability assessment.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance for which the vulnerability assessment is defined.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @param parameters The requested resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a managed instance vulnerability assessment on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ManagedInstanceVulnerabilityAssessmentInner> createOrUpdateAsync(
        String resourceGroupName,
        String managedInstanceName,
        VulnerabilityAssessmentName vulnerabilityAssessmentName,
        ManagedInstanceVulnerabilityAssessmentInner parameters);

    /**
     * Creates or updates the managed instance's vulnerability assessment.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance for which the vulnerability assessment is defined.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @param parameters The requested resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a managed instance vulnerability assessment.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ManagedInstanceVulnerabilityAssessmentInner createOrUpdate(
        String resourceGroupName,
        String managedInstanceName,
        VulnerabilityAssessmentName vulnerabilityAssessmentName,
        ManagedInstanceVulnerabilityAssessmentInner parameters);

    /**
     * Creates or updates the managed instance's vulnerability assessment.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance for which the vulnerability assessment is defined.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @param parameters The requested resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a managed instance vulnerability assessment along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ManagedInstanceVulnerabilityAssessmentInner> createOrUpdateWithResponse(
        String resourceGroupName,
        String managedInstanceName,
        VulnerabilityAssessmentName vulnerabilityAssessmentName,
        ManagedInstanceVulnerabilityAssessmentInner parameters,
        Context context);

    /**
     * Removes the managed instance's vulnerability assessment.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance for which the vulnerability assessment is defined.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deleteWithResponseAsync(
        String resourceGroupName, String managedInstanceName, VulnerabilityAssessmentName vulnerabilityAssessmentName);

    /**
     * Removes the managed instance's vulnerability assessment.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance for which the vulnerability assessment is defined.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAsync(
        String resourceGroupName, String managedInstanceName, VulnerabilityAssessmentName vulnerabilityAssessmentName);

    /**
     * Removes the managed instance's vulnerability assessment.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance for which the vulnerability assessment is defined.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(
        String resourceGroupName, String managedInstanceName, VulnerabilityAssessmentName vulnerabilityAssessmentName);

    /**
     * Removes the managed instance's vulnerability assessment.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance for which the vulnerability assessment is defined.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteWithResponse(
        String resourceGroupName,
        String managedInstanceName,
        VulnerabilityAssessmentName vulnerabilityAssessmentName,
        Context context);

    /**
     * Gets the managed instance's vulnerability assessment policies.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance for which the vulnerability assessments is defined.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the managed instance's vulnerability assessment policies as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<ManagedInstanceVulnerabilityAssessmentInner> listByInstanceAsync(
        String resourceGroupName, String managedInstanceName);

    /**
     * Gets the managed instance's vulnerability assessment policies.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance for which the vulnerability assessments is defined.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the managed instance's vulnerability assessment policies as paginated response with {@link
     *     PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ManagedInstanceVulnerabilityAssessmentInner> listByInstance(
        String resourceGroupName, String managedInstanceName);

    /**
     * Gets the managed instance's vulnerability assessment policies.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance for which the vulnerability assessments is defined.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the managed instance's vulnerability assessment policies as paginated response with {@link
     *     PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ManagedInstanceVulnerabilityAssessmentInner> listByInstance(
        String resourceGroupName, String managedInstanceName, Context context);
}
