/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.sql.models.CapabilityStatus;
import com.azure.resourcemanager.sql.models.ReadScaleCapability;
import com.azure.resourcemanager.sql.models.ServiceObjectiveCapability;
import com.azure.resourcemanager.sql.models.StorageCapability;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class EditionCapability {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(EditionCapability.class);
    @JsonProperty(value="name", access=JsonProperty.Access.WRITE_ONLY)
    private String name;
    @JsonProperty(value="supportedServiceLevelObjectives", access=JsonProperty.Access.WRITE_ONLY)
    private List<ServiceObjectiveCapability> supportedServiceLevelObjectives;
    @JsonProperty(value="zoneRedundant", access=JsonProperty.Access.WRITE_ONLY)
    private Boolean zoneRedundant;
    @JsonProperty(value="readScale", access=JsonProperty.Access.WRITE_ONLY)
    private ReadScaleCapability readScale;
    @JsonProperty(value="supportedStorageCapabilities", access=JsonProperty.Access.WRITE_ONLY)
    private List<StorageCapability> supportedStorageCapabilities;
    @JsonProperty(value="status", access=JsonProperty.Access.WRITE_ONLY)
    private CapabilityStatus status;
    @JsonProperty(value="reason")
    private String reason;

    public String name() {
        return this.name;
    }

    public List<ServiceObjectiveCapability> supportedServiceLevelObjectives() {
        return this.supportedServiceLevelObjectives;
    }

    public Boolean zoneRedundant() {
        return this.zoneRedundant;
    }

    public ReadScaleCapability readScale() {
        return this.readScale;
    }

    public List<StorageCapability> supportedStorageCapabilities() {
        return this.supportedStorageCapabilities;
    }

    public CapabilityStatus status() {
        return this.status;
    }

    public String reason() {
        return this.reason;
    }

    public EditionCapability withReason(String reason) {
        this.reason = reason;
        return this;
    }

    public void validate() {
        if (this.supportedServiceLevelObjectives() != null) {
            this.supportedServiceLevelObjectives().forEach(e -> e.validate());
        }
        if (this.readScale() != null) {
            this.readScale().validate();
        }
        if (this.supportedStorageCapabilities() != null) {
            this.supportedStorageCapabilities().forEach(e -> e.validate());
        }
    }
}

