/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.servicebus.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.servicebus.models.KeySource;
import com.azure.resourcemanager.servicebus.models.KeyVaultProperties;
import java.io.IOException;
import java.util.List;

public final class Encryption
implements JsonSerializable<Encryption> {
    private List<KeyVaultProperties> keyVaultProperties;
    private KeySource keySource;
    private Boolean requireInfrastructureEncryption;

    public List<KeyVaultProperties> keyVaultProperties() {
        return this.keyVaultProperties;
    }

    public Encryption withKeyVaultProperties(List<KeyVaultProperties> keyVaultProperties) {
        this.keyVaultProperties = keyVaultProperties;
        return this;
    }

    public KeySource keySource() {
        return this.keySource;
    }

    public Encryption withKeySource(KeySource keySource) {
        this.keySource = keySource;
        return this;
    }

    public Boolean requireInfrastructureEncryption() {
        return this.requireInfrastructureEncryption;
    }

    public Encryption withRequireInfrastructureEncryption(Boolean requireInfrastructureEncryption) {
        this.requireInfrastructureEncryption = requireInfrastructureEncryption;
        return this;
    }

    public void validate() {
        if (this.keyVaultProperties() != null) {
            this.keyVaultProperties().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("keyVaultProperties", this.keyVaultProperties, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("keySource", this.keySource == null ? null : this.keySource.toString());
        jsonWriter.writeBooleanField("requireInfrastructureEncryption", this.requireInfrastructureEncryption);
        return jsonWriter.writeEndObject();
    }

    public static Encryption fromJson(JsonReader jsonReader) throws IOException {
        return (Encryption)jsonReader.readObject(reader -> {
            Encryption deserializedEncryption = new Encryption();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("keyVaultProperties".equals(fieldName)) {
                    List keyVaultProperties;
                    deserializedEncryption.keyVaultProperties = keyVaultProperties = reader.readArray(reader1 -> KeyVaultProperties.fromJson(reader1));
                    continue;
                }
                if ("keySource".equals(fieldName)) {
                    deserializedEncryption.keySource = KeySource.fromString(reader.getString());
                    continue;
                }
                if ("requireInfrastructureEncryption".equals(fieldName)) {
                    deserializedEncryption.requireInfrastructureEncryption = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEncryption;
        });
    }
}

