/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.servicebus.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.servicebus.fluent.RulesClient;
import com.azure.resourcemanager.servicebus.fluent.models.RuleInner;
import com.azure.resourcemanager.servicebus.implementation.ServiceBusManagementClientImpl;
import com.azure.resourcemanager.servicebus.models.RuleListResult;
import reactor.core.publisher.Mono;

public final class RulesClientImpl
implements RulesClient {
    private final RulesService service;
    private final ServiceBusManagementClientImpl client;

    RulesClientImpl(ServiceBusManagementClientImpl client) {
        this.service = (RulesService)RestProxy.create(RulesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RuleInner>> listBySubscriptionsSinglePageAsync(String resourceGroupName, String namespaceName, String topicName, String subscriptionName, Integer skip, Integer top) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (subscriptionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listBySubscriptions(this.client.getEndpoint(), resourceGroupName, namespaceName, topicName, subscriptionName, this.client.getApiVersion(), this.client.getSubscriptionId(), skip, top, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RuleListResult)res.getValue()).value(), ((RuleListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RuleInner>> listBySubscriptionsSinglePageAsync(String resourceGroupName, String namespaceName, String topicName, String subscriptionName, Integer skip, Integer top, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (subscriptionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listBySubscriptions(this.client.getEndpoint(), resourceGroupName, namespaceName, topicName, subscriptionName, this.client.getApiVersion(), this.client.getSubscriptionId(), skip, top, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RuleListResult)res.getValue()).value(), ((RuleListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<RuleInner> listBySubscriptionsAsync(String resourceGroupName, String namespaceName, String topicName, String subscriptionName, Integer skip, Integer top) {
        return new PagedFlux(() -> this.listBySubscriptionsSinglePageAsync(resourceGroupName, namespaceName, topicName, subscriptionName, skip, top), nextLink -> this.listBySubscriptionsNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<RuleInner> listBySubscriptionsAsync(String resourceGroupName, String namespaceName, String topicName, String subscriptionName) {
        Integer skip = null;
        Integer top = null;
        return new PagedFlux(() -> this.listBySubscriptionsSinglePageAsync(resourceGroupName, namespaceName, topicName, subscriptionName, skip, top), nextLink -> this.listBySubscriptionsNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<RuleInner> listBySubscriptionsAsync(String resourceGroupName, String namespaceName, String topicName, String subscriptionName, Integer skip, Integer top, Context context) {
        return new PagedFlux(() -> this.listBySubscriptionsSinglePageAsync(resourceGroupName, namespaceName, topicName, subscriptionName, skip, top, context), nextLink -> this.listBySubscriptionsNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RuleInner> listBySubscriptions(String resourceGroupName, String namespaceName, String topicName, String subscriptionName) {
        Integer skip = null;
        Integer top = null;
        return new PagedIterable(this.listBySubscriptionsAsync(resourceGroupName, namespaceName, topicName, subscriptionName, skip, top));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RuleInner> listBySubscriptions(String resourceGroupName, String namespaceName, String topicName, String subscriptionName, Integer skip, Integer top, Context context) {
        return new PagedIterable(this.listBySubscriptionsAsync(resourceGroupName, namespaceName, topicName, subscriptionName, skip, top, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RuleInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String namespaceName, String topicName, String subscriptionName, String ruleName, RuleInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (subscriptionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionName is required and cannot be null."));
        }
        if (ruleName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ruleName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, namespaceName, topicName, subscriptionName, ruleName, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RuleInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String namespaceName, String topicName, String subscriptionName, String ruleName, RuleInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (subscriptionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionName is required and cannot be null."));
        }
        if (ruleName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ruleName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, namespaceName, topicName, subscriptionName, ruleName, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RuleInner> createOrUpdateAsync(String resourceGroupName, String namespaceName, String topicName, String subscriptionName, String ruleName, RuleInner parameters) {
        return this.createOrUpdateWithResponseAsync(resourceGroupName, namespaceName, topicName, subscriptionName, ruleName, parameters).flatMap(res -> Mono.justOrEmpty((Object)((Object)((RuleInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RuleInner> createOrUpdateWithResponse(String resourceGroupName, String namespaceName, String topicName, String subscriptionName, String ruleName, RuleInner parameters, Context context) {
        return (Response)this.createOrUpdateWithResponseAsync(resourceGroupName, namespaceName, topicName, subscriptionName, ruleName, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RuleInner createOrUpdate(String resourceGroupName, String namespaceName, String topicName, String subscriptionName, String ruleName, RuleInner parameters) {
        return (RuleInner)((Object)this.createOrUpdateWithResponse(resourceGroupName, namespaceName, topicName, subscriptionName, ruleName, parameters, Context.NONE).getValue());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String namespaceName, String topicName, String subscriptionName, String ruleName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (subscriptionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionName is required and cannot be null."));
        }
        if (ruleName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ruleName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, namespaceName, topicName, subscriptionName, ruleName, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String namespaceName, String topicName, String subscriptionName, String ruleName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (subscriptionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionName is required and cannot be null."));
        }
        if (ruleName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ruleName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, namespaceName, topicName, subscriptionName, ruleName, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String namespaceName, String topicName, String subscriptionName, String ruleName) {
        return this.deleteWithResponseAsync(resourceGroupName, namespaceName, topicName, subscriptionName, ruleName).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String resourceGroupName, String namespaceName, String topicName, String subscriptionName, String ruleName, Context context) {
        return (Response)this.deleteWithResponseAsync(resourceGroupName, namespaceName, topicName, subscriptionName, ruleName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String namespaceName, String topicName, String subscriptionName, String ruleName) {
        this.deleteWithResponse(resourceGroupName, namespaceName, topicName, subscriptionName, ruleName, Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RuleInner>> getWithResponseAsync(String resourceGroupName, String namespaceName, String topicName, String subscriptionName, String ruleName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (subscriptionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionName is required and cannot be null."));
        }
        if (ruleName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ruleName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, namespaceName, topicName, subscriptionName, ruleName, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RuleInner>> getWithResponseAsync(String resourceGroupName, String namespaceName, String topicName, String subscriptionName, String ruleName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (subscriptionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionName is required and cannot be null."));
        }
        if (ruleName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ruleName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, namespaceName, topicName, subscriptionName, ruleName, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RuleInner> getAsync(String resourceGroupName, String namespaceName, String topicName, String subscriptionName, String ruleName) {
        return this.getWithResponseAsync(resourceGroupName, namespaceName, topicName, subscriptionName, ruleName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((RuleInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RuleInner> getWithResponse(String resourceGroupName, String namespaceName, String topicName, String subscriptionName, String ruleName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, namespaceName, topicName, subscriptionName, ruleName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RuleInner get(String resourceGroupName, String namespaceName, String topicName, String subscriptionName, String ruleName) {
        return (RuleInner)((Object)this.getWithResponse(resourceGroupName, namespaceName, topicName, subscriptionName, ruleName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RuleInner>> listBySubscriptionsNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listBySubscriptionsNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RuleListResult)res.getValue()).value(), ((RuleListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RuleInner>> listBySubscriptionsNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listBySubscriptionsNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RuleListResult)res.getValue()).value(), ((RuleListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ServiceBusManagement")
    public static interface RulesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/topics/{topicName}/subscriptions/{subscriptionName}/rules")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RuleListResult>> listBySubscriptions(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="namespaceName") String var3, @PathParam(value="topicName") String var4, @PathParam(value="subscriptionName") String var5, @QueryParam(value="api-version") String var6, @PathParam(value="subscriptionId") String var7, @QueryParam(value="$skip") Integer var8, @QueryParam(value="$top") Integer var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/topics/{topicName}/subscriptions/{subscriptionName}/rules/{ruleName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RuleInner>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="namespaceName") String var3, @PathParam(value="topicName") String var4, @PathParam(value="subscriptionName") String var5, @PathParam(value="ruleName") String var6, @QueryParam(value="api-version") String var7, @PathParam(value="subscriptionId") String var8, @BodyParam(value="application/json") RuleInner var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/topics/{topicName}/subscriptions/{subscriptionName}/rules/{ruleName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="namespaceName") String var3, @PathParam(value="topicName") String var4, @PathParam(value="subscriptionName") String var5, @PathParam(value="ruleName") String var6, @QueryParam(value="api-version") String var7, @PathParam(value="subscriptionId") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/topics/{topicName}/subscriptions/{subscriptionName}/rules/{ruleName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RuleInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="namespaceName") String var3, @PathParam(value="topicName") String var4, @PathParam(value="subscriptionName") String var5, @PathParam(value="ruleName") String var6, @QueryParam(value="api-version") String var7, @PathParam(value="subscriptionId") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RuleListResult>> listBySubscriptionsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

