/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.servicebus.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.servicebus.fluent.models.SBTopicProperties;
import com.azure.resourcemanager.servicebus.models.EntityStatus;
import com.azure.resourcemanager.servicebus.models.MessageCountDetails;
import java.io.IOException;
import java.time.Duration;
import java.time.OffsetDateTime;

public final class SBTopicInner
extends Resource {
    private SBTopicProperties innerProperties;
    private SystemData systemData;
    private String location;
    private String id;
    private String name;
    private String type;

    private SBTopicProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String location() {
        return this.location;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public Long sizeInBytes() {
        return this.innerProperties() == null ? null : this.innerProperties().sizeInBytes();
    }

    public OffsetDateTime createdAt() {
        return this.innerProperties() == null ? null : this.innerProperties().createdAt();
    }

    public OffsetDateTime updatedAt() {
        return this.innerProperties() == null ? null : this.innerProperties().updatedAt();
    }

    public OffsetDateTime accessedAt() {
        return this.innerProperties() == null ? null : this.innerProperties().accessedAt();
    }

    public Integer subscriptionCount() {
        return this.innerProperties() == null ? null : this.innerProperties().subscriptionCount();
    }

    public MessageCountDetails countDetails() {
        return this.innerProperties() == null ? null : this.innerProperties().countDetails();
    }

    public Duration defaultMessageTimeToLive() {
        return this.innerProperties() == null ? null : this.innerProperties().defaultMessageTimeToLive();
    }

    public SBTopicInner withDefaultMessageTimeToLive(Duration defaultMessageTimeToLive) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SBTopicProperties();
        }
        this.innerProperties().withDefaultMessageTimeToLive(defaultMessageTimeToLive);
        return this;
    }

    public Integer maxSizeInMegabytes() {
        return this.innerProperties() == null ? null : this.innerProperties().maxSizeInMegabytes();
    }

    public SBTopicInner withMaxSizeInMegabytes(Integer maxSizeInMegabytes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SBTopicProperties();
        }
        this.innerProperties().withMaxSizeInMegabytes(maxSizeInMegabytes);
        return this;
    }

    public Long maxMessageSizeInKilobytes() {
        return this.innerProperties() == null ? null : this.innerProperties().maxMessageSizeInKilobytes();
    }

    public SBTopicInner withMaxMessageSizeInKilobytes(Long maxMessageSizeInKilobytes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SBTopicProperties();
        }
        this.innerProperties().withMaxMessageSizeInKilobytes(maxMessageSizeInKilobytes);
        return this;
    }

    public Boolean requiresDuplicateDetection() {
        return this.innerProperties() == null ? null : this.innerProperties().requiresDuplicateDetection();
    }

    public SBTopicInner withRequiresDuplicateDetection(Boolean requiresDuplicateDetection) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SBTopicProperties();
        }
        this.innerProperties().withRequiresDuplicateDetection(requiresDuplicateDetection);
        return this;
    }

    public Duration duplicateDetectionHistoryTimeWindow() {
        return this.innerProperties() == null ? null : this.innerProperties().duplicateDetectionHistoryTimeWindow();
    }

    public SBTopicInner withDuplicateDetectionHistoryTimeWindow(Duration duplicateDetectionHistoryTimeWindow) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SBTopicProperties();
        }
        this.innerProperties().withDuplicateDetectionHistoryTimeWindow(duplicateDetectionHistoryTimeWindow);
        return this;
    }

    public Boolean enableBatchedOperations() {
        return this.innerProperties() == null ? null : this.innerProperties().enableBatchedOperations();
    }

    public SBTopicInner withEnableBatchedOperations(Boolean enableBatchedOperations) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SBTopicProperties();
        }
        this.innerProperties().withEnableBatchedOperations(enableBatchedOperations);
        return this;
    }

    public EntityStatus status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    public SBTopicInner withStatus(EntityStatus status) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SBTopicProperties();
        }
        this.innerProperties().withStatus(status);
        return this;
    }

    public Boolean supportOrdering() {
        return this.innerProperties() == null ? null : this.innerProperties().supportOrdering();
    }

    public SBTopicInner withSupportOrdering(Boolean supportOrdering) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SBTopicProperties();
        }
        this.innerProperties().withSupportOrdering(supportOrdering);
        return this;
    }

    public Duration autoDeleteOnIdle() {
        return this.innerProperties() == null ? null : this.innerProperties().autoDeleteOnIdle();
    }

    public SBTopicInner withAutoDeleteOnIdle(Duration autoDeleteOnIdle) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SBTopicProperties();
        }
        this.innerProperties().withAutoDeleteOnIdle(autoDeleteOnIdle);
        return this;
    }

    public Boolean enablePartitioning() {
        return this.innerProperties() == null ? null : this.innerProperties().enablePartitioning();
    }

    public SBTopicInner withEnablePartitioning(Boolean enablePartitioning) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SBTopicProperties();
        }
        this.innerProperties().withEnablePartitioning(enablePartitioning);
        return this;
    }

    public Boolean enableExpress() {
        return this.innerProperties() == null ? null : this.innerProperties().enableExpress();
    }

    public SBTopicInner withEnableExpress(Boolean enableExpress) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SBTopicProperties();
        }
        this.innerProperties().withEnableExpress(enableExpress);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static SBTopicInner fromJson(JsonReader jsonReader) throws IOException {
        return (SBTopicInner)((Object)jsonReader.readObject(reader -> {
            SBTopicInner deserializedSBTopicInner = new SBTopicInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedSBTopicInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedSBTopicInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSBTopicInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedSBTopicInner.innerProperties = SBTopicProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedSBTopicInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedSBTopicInner.location = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSBTopicInner;
        }));
    }
}

