/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.servicebus.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.servicebus.models.SkuName;
import com.azure.resourcemanager.servicebus.models.SkuTier;
import java.io.IOException;

public final class SBSku
implements JsonSerializable<SBSku> {
    private SkuName name;
    private SkuTier tier;
    private Integer capacity;
    private static final ClientLogger LOGGER = new ClientLogger(SBSku.class);

    public SkuName name() {
        return this.name;
    }

    public SBSku withName(SkuName name) {
        this.name = name;
        return this;
    }

    public SkuTier tier() {
        return this.tier;
    }

    public SBSku withTier(SkuTier tier) {
        this.tier = tier;
        return this;
    }

    public Integer capacity() {
        return this.capacity;
    }

    public SBSku withCapacity(Integer capacity) {
        this.capacity = capacity;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model SBSku"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name == null ? null : this.name.toString());
        jsonWriter.writeStringField("tier", this.tier == null ? null : this.tier.toString());
        jsonWriter.writeNumberField("capacity", (Number)this.capacity);
        return jsonWriter.writeEndObject();
    }

    public static SBSku fromJson(JsonReader jsonReader) throws IOException {
        return (SBSku)jsonReader.readObject(reader -> {
            SBSku deserializedSBSku = new SBSku();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedSBSku.name = SkuName.fromString(reader.getString());
                    continue;
                }
                if ("tier".equals(fieldName)) {
                    deserializedSBSku.tier = SkuTier.fromString(reader.getString());
                    continue;
                }
                if ("capacity".equals(fieldName)) {
                    deserializedSBSku.capacity = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSBSku;
        });
    }
}

