// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.servicebus.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Single item in List or Get Migration Config operation.
 */
@Fluent
public final class MigrationConfigPropertiesInner extends ProxyResource {
    /*
     * Properties required to the Create Migration Configuration
     */
    private MigrationConfigPropertiesProperties innerProperties;

    /*
     * The system meta data relating to this resource.
     */
    private SystemData systemData;

    /*
     * The geo-location where the resource lives
     */
    private String location;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * The type of the resource.
     */
    private String type;

    /**
     * Creates an instance of MigrationConfigPropertiesInner class.
     */
    public MigrationConfigPropertiesInner() {
    }

    /**
     * Get the innerProperties property: Properties required to the Create Migration Configuration.
     * 
     * @return the innerProperties value.
     */
    private MigrationConfigPropertiesProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the systemData property: The system meta data relating to this resource.
     * 
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the location property: The geo-location where the resource lives.
     * 
     * @return the location value.
     */
    public String location() {
        return this.location;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the provisioningState property: Provisioning state of Migration Configuration.
     * 
     * @return the provisioningState value.
     */
    public String provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the pendingReplicationOperationsCount property: Number of entities pending to be replicated.
     * 
     * @return the pendingReplicationOperationsCount value.
     */
    public Long pendingReplicationOperationsCount() {
        return this.innerProperties() == null ? null : this.innerProperties().pendingReplicationOperationsCount();
    }

    /**
     * Get the targetNamespace property: Existing premium Namespace ARM Id name which has no entities, will be used for
     * migration.
     * 
     * @return the targetNamespace value.
     */
    public String targetNamespace() {
        return this.innerProperties() == null ? null : this.innerProperties().targetNamespace();
    }

    /**
     * Set the targetNamespace property: Existing premium Namespace ARM Id name which has no entities, will be used for
     * migration.
     * 
     * @param targetNamespace the targetNamespace value to set.
     * @return the MigrationConfigPropertiesInner object itself.
     */
    public MigrationConfigPropertiesInner withTargetNamespace(String targetNamespace) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MigrationConfigPropertiesProperties();
        }
        this.innerProperties().withTargetNamespace(targetNamespace);
        return this;
    }

    /**
     * Get the postMigrationName property: Name to access Standard Namespace after migration.
     * 
     * @return the postMigrationName value.
     */
    public String postMigrationName() {
        return this.innerProperties() == null ? null : this.innerProperties().postMigrationName();
    }

    /**
     * Set the postMigrationName property: Name to access Standard Namespace after migration.
     * 
     * @param postMigrationName the postMigrationName value to set.
     * @return the MigrationConfigPropertiesInner object itself.
     */
    public MigrationConfigPropertiesInner withPostMigrationName(String postMigrationName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MigrationConfigPropertiesProperties();
        }
        this.innerProperties().withPostMigrationName(postMigrationName);
        return this;
    }

    /**
     * Get the migrationState property: State in which Standard to Premium Migration is, possible values : Unknown,
     * Reverting, Completing, Initiating, Syncing, Active.
     * 
     * @return the migrationState value.
     */
    public String migrationState() {
        return this.innerProperties() == null ? null : this.innerProperties().migrationState();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MigrationConfigPropertiesInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MigrationConfigPropertiesInner if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the MigrationConfigPropertiesInner.
     */
    public static MigrationConfigPropertiesInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MigrationConfigPropertiesInner deserializedMigrationConfigPropertiesInner
                = new MigrationConfigPropertiesInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMigrationConfigPropertiesInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedMigrationConfigPropertiesInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedMigrationConfigPropertiesInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedMigrationConfigPropertiesInner.innerProperties
                        = MigrationConfigPropertiesProperties.fromJson(reader);
                } else if ("systemData".equals(fieldName)) {
                    deserializedMigrationConfigPropertiesInner.systemData = SystemData.fromJson(reader);
                } else if ("location".equals(fieldName)) {
                    deserializedMigrationConfigPropertiesInner.location = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMigrationConfigPropertiesInner;
        });
    }
}
