/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.servicebus.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.servicebus.fluent.models.RuleInner;
import java.io.IOException;
import java.util.List;

public final class RuleListResult
implements JsonSerializable<RuleListResult> {
    private List<RuleInner> value;
    private String nextLink;

    public List<RuleInner> value() {
        return this.value;
    }

    public RuleListResult withValue(List<RuleInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public RuleListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static RuleListResult fromJson(JsonReader jsonReader) throws IOException {
        return (RuleListResult)jsonReader.readObject(reader -> {
            RuleListResult deserializedRuleListResult = new RuleListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedRuleListResult.value = value = reader.readArray(reader1 -> RuleInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedRuleListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRuleListResult;
        });
    }
}

