// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.servicebus.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Message Count Details.
 */
@Immutable
public final class MessageCountDetails implements JsonSerializable<MessageCountDetails> {
    /*
     * Number of active messages in the queue, topic, or subscription.
     */
    private Long activeMessageCount;

    /*
     * Number of messages that are dead lettered.
     */
    private Long deadLetterMessageCount;

    /*
     * Number of scheduled messages.
     */
    private Long scheduledMessageCount;

    /*
     * Number of messages transferred to another queue, topic, or subscription.
     */
    private Long transferMessageCount;

    /*
     * Number of messages transferred into dead letters.
     */
    private Long transferDeadLetterMessageCount;

    /**
     * Creates an instance of MessageCountDetails class.
     */
    public MessageCountDetails() {
    }

    /**
     * Get the activeMessageCount property: Number of active messages in the queue, topic, or subscription.
     * 
     * @return the activeMessageCount value.
     */
    public Long activeMessageCount() {
        return this.activeMessageCount;
    }

    /**
     * Get the deadLetterMessageCount property: Number of messages that are dead lettered.
     * 
     * @return the deadLetterMessageCount value.
     */
    public Long deadLetterMessageCount() {
        return this.deadLetterMessageCount;
    }

    /**
     * Get the scheduledMessageCount property: Number of scheduled messages.
     * 
     * @return the scheduledMessageCount value.
     */
    public Long scheduledMessageCount() {
        return this.scheduledMessageCount;
    }

    /**
     * Get the transferMessageCount property: Number of messages transferred to another queue, topic, or subscription.
     * 
     * @return the transferMessageCount value.
     */
    public Long transferMessageCount() {
        return this.transferMessageCount;
    }

    /**
     * Get the transferDeadLetterMessageCount property: Number of messages transferred into dead letters.
     * 
     * @return the transferDeadLetterMessageCount value.
     */
    public Long transferDeadLetterMessageCount() {
        return this.transferDeadLetterMessageCount;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MessageCountDetails from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MessageCountDetails if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the MessageCountDetails.
     */
    public static MessageCountDetails fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MessageCountDetails deserializedMessageCountDetails = new MessageCountDetails();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("activeMessageCount".equals(fieldName)) {
                    deserializedMessageCountDetails.activeMessageCount = reader.getNullable(JsonReader::getLong);
                } else if ("deadLetterMessageCount".equals(fieldName)) {
                    deserializedMessageCountDetails.deadLetterMessageCount = reader.getNullable(JsonReader::getLong);
                } else if ("scheduledMessageCount".equals(fieldName)) {
                    deserializedMessageCountDetails.scheduledMessageCount = reader.getNullable(JsonReader::getLong);
                } else if ("transferMessageCount".equals(fieldName)) {
                    deserializedMessageCountDetails.transferMessageCount = reader.getNullable(JsonReader::getLong);
                } else if ("transferDeadLetterMessageCount".equals(fieldName)) {
                    deserializedMessageCountDetails.transferDeadLetterMessageCount
                        = reader.getNullable(JsonReader::getLong);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMessageCountDetails;
        });
    }
}
