// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.servicebus.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Represents a filter which is a composition of an expression and an action that is executed in the pub/sub pipeline.
 */
@Fluent
public final class SqlFilter implements JsonSerializable<SqlFilter> {
    /*
     * The SQL expression. e.g. MyProperty='ABC'
     */
    private String sqlExpression;

    /*
     * This property is reserved for future use. An integer value showing the compatibility level, currently hard-coded
     * to 20.
     */
    private Integer compatibilityLevel;

    /*
     * Value that indicates whether the rule action requires preprocessing.
     */
    private Boolean requiresPreprocessing;

    /**
     * Creates an instance of SqlFilter class.
     */
    public SqlFilter() {
    }

    /**
     * Get the sqlExpression property: The SQL expression. e.g. MyProperty='ABC'.
     * 
     * @return the sqlExpression value.
     */
    public String sqlExpression() {
        return this.sqlExpression;
    }

    /**
     * Set the sqlExpression property: The SQL expression. e.g. MyProperty='ABC'.
     * 
     * @param sqlExpression the sqlExpression value to set.
     * @return the SqlFilter object itself.
     */
    public SqlFilter withSqlExpression(String sqlExpression) {
        this.sqlExpression = sqlExpression;
        return this;
    }

    /**
     * Get the compatibilityLevel property: This property is reserved for future use. An integer value showing the
     * compatibility level, currently hard-coded to 20.
     * 
     * @return the compatibilityLevel value.
     */
    public Integer compatibilityLevel() {
        return this.compatibilityLevel;
    }

    /**
     * Set the compatibilityLevel property: This property is reserved for future use. An integer value showing the
     * compatibility level, currently hard-coded to 20.
     * 
     * @param compatibilityLevel the compatibilityLevel value to set.
     * @return the SqlFilter object itself.
     */
    public SqlFilter withCompatibilityLevel(Integer compatibilityLevel) {
        this.compatibilityLevel = compatibilityLevel;
        return this;
    }

    /**
     * Get the requiresPreprocessing property: Value that indicates whether the rule action requires preprocessing.
     * 
     * @return the requiresPreprocessing value.
     */
    public Boolean requiresPreprocessing() {
        return this.requiresPreprocessing;
    }

    /**
     * Set the requiresPreprocessing property: Value that indicates whether the rule action requires preprocessing.
     * 
     * @param requiresPreprocessing the requiresPreprocessing value to set.
     * @return the SqlFilter object itself.
     */
    public SqlFilter withRequiresPreprocessing(Boolean requiresPreprocessing) {
        this.requiresPreprocessing = requiresPreprocessing;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("sqlExpression", this.sqlExpression);
        jsonWriter.writeNumberField("compatibilityLevel", this.compatibilityLevel);
        jsonWriter.writeBooleanField("requiresPreprocessing", this.requiresPreprocessing);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SqlFilter from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SqlFilter if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IOException If an error occurs while reading the SqlFilter.
     */
    public static SqlFilter fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SqlFilter deserializedSqlFilter = new SqlFilter();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("sqlExpression".equals(fieldName)) {
                    deserializedSqlFilter.sqlExpression = reader.getString();
                } else if ("compatibilityLevel".equals(fieldName)) {
                    deserializedSqlFilter.compatibilityLevel = reader.getNullable(JsonReader::getInt);
                } else if ("requiresPreprocessing".equals(fieldName)) {
                    deserializedSqlFilter.requiresPreprocessing = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSqlFilter;
        });
    }
}
