// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.servicebus.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Safe failover is to indicate the service should wait for pending replication to finish before switching to the
 * secondary.
 */
@Fluent
public final class FailoverPropertiesProperties implements JsonSerializable<FailoverPropertiesProperties> {
    /*
     * Safe failover is to indicate the service should wait for pending replication to finish before switching to the
     * secondary.
     */
    private Boolean isSafeFailover;

    /**
     * Creates an instance of FailoverPropertiesProperties class.
     */
    public FailoverPropertiesProperties() {
    }

    /**
     * Get the isSafeFailover property: Safe failover is to indicate the service should wait for pending replication to
     * finish before switching to the secondary.
     * 
     * @return the isSafeFailover value.
     */
    public Boolean isSafeFailover() {
        return this.isSafeFailover;
    }

    /**
     * Set the isSafeFailover property: Safe failover is to indicate the service should wait for pending replication to
     * finish before switching to the secondary.
     * 
     * @param isSafeFailover the isSafeFailover value to set.
     * @return the FailoverPropertiesProperties object itself.
     */
    public FailoverPropertiesProperties withIsSafeFailover(Boolean isSafeFailover) {
        this.isSafeFailover = isSafeFailover;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("IsSafeFailover", this.isSafeFailover);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of FailoverPropertiesProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of FailoverPropertiesProperties if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the FailoverPropertiesProperties.
     */
    public static FailoverPropertiesProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FailoverPropertiesProperties deserializedFailoverPropertiesProperties = new FailoverPropertiesProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("IsSafeFailover".equals(fieldName)) {
                    deserializedFailoverPropertiesProperties.isSafeFailover
                        = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedFailoverPropertiesProperties;
        });
    }
}
