// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.servicebus.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/** SKU of the namespace. */
@Fluent
public final class SBSku {
    /*
     * Name of this SKU.
     */
    @JsonProperty(value = "name", required = true)
    private SkuName name;

    /*
     * The billing tier of this particular SKU.
     */
    @JsonProperty(value = "tier")
    private SkuTier tier;

    /*
     * The specified messaging units for the tier. For Premium tier, capacity are 1,2 and 4.
     */
    @JsonProperty(value = "capacity")
    private Integer capacity;

    /**
     * Get the name property: Name of this SKU.
     *
     * @return the name value.
     */
    public SkuName name() {
        return this.name;
    }

    /**
     * Set the name property: Name of this SKU.
     *
     * @param name the name value to set.
     * @return the SBSku object itself.
     */
    public SBSku withName(SkuName name) {
        this.name = name;
        return this;
    }

    /**
     * Get the tier property: The billing tier of this particular SKU.
     *
     * @return the tier value.
     */
    public SkuTier tier() {
        return this.tier;
    }

    /**
     * Set the tier property: The billing tier of this particular SKU.
     *
     * @param tier the tier value to set.
     * @return the SBSku object itself.
     */
    public SBSku withTier(SkuTier tier) {
        this.tier = tier;
        return this;
    }

    /**
     * Get the capacity property: The specified messaging units for the tier. For Premium tier, capacity are 1,2 and 4.
     *
     * @return the capacity value.
     */
    public Integer capacity() {
        return this.capacity;
    }

    /**
     * Set the capacity property: The specified messaging units for the tier. For Premium tier, capacity are 1,2 and 4.
     *
     * @param capacity the capacity value to set.
     * @return the SBSku object itself.
     */
    public SBSku withCapacity(Integer capacity) {
        this.capacity = capacity;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (name() == null) {
            throw LOGGER
                .logExceptionAsError(new IllegalArgumentException("Missing required property name in model SBSku"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(SBSku.class);
}
