// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.servicebus.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/** Defines values for NameSpaceType. */
public enum NameSpaceType {
    /** Enum value Messaging. */
    MESSAGING("Messaging"),

    /** Enum value NotificationHub. */
    NOTIFICATION_HUB("NotificationHub"),

    /** Enum value Mixed. */
    MIXED("Mixed"),

    /** Enum value EventHub. */
    EVENT_HUB("EventHub"),

    /** Enum value Relay. */
    RELAY("Relay");

    /** The actual serialized value for a NameSpaceType instance. */
    private final String value;

    NameSpaceType(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a NameSpaceType instance.
     *
     * @param value the serialized value to parse.
     * @return the parsed NameSpaceType object, or null if unable to parse.
     */
    @JsonCreator
    public static NameSpaceType fromString(String value) {
        NameSpaceType[] items = NameSpaceType.values();
        for (NameSpaceType item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    @JsonValue
    @Override
    public String toString() {
        return this.value;
    }
}
