// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.servicebus.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.servicebus.fluent.models.MigrationConfigPropertiesInner;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The result of the List migrationConfigurations operation. */
@Fluent
public final class MigrationConfigListResult {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(MigrationConfigListResult.class);

    /*
     * List of Migration Configs
     */
    @JsonProperty(value = "value")
    private List<MigrationConfigPropertiesInner> value;

    /*
     * Link to the next set of results. Not empty if Value contains incomplete
     * list of migrationConfigurations
     */
    @JsonProperty(value = "nextLink", access = JsonProperty.Access.WRITE_ONLY)
    private String nextLink;

    /**
     * Get the value property: List of Migration Configs.
     *
     * @return the value value.
     */
    public List<MigrationConfigPropertiesInner> value() {
        return this.value;
    }

    /**
     * Set the value property: List of Migration Configs.
     *
     * @param value the value value to set.
     * @return the MigrationConfigListResult object itself.
     */
    public MigrationConfigListResult withValue(List<MigrationConfigPropertiesInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: Link to the next set of results. Not empty if Value contains incomplete list of
     * migrationConfigurations.
     *
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
