/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.search.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.search.fluent.AdminKeysClient;
import com.azure.resourcemanager.search.fluent.NetworkSecurityPerimeterConfigurationsClient;
import com.azure.resourcemanager.search.fluent.OperationsClient;
import com.azure.resourcemanager.search.fluent.PrivateEndpointConnectionsClient;
import com.azure.resourcemanager.search.fluent.PrivateLinkResourcesClient;
import com.azure.resourcemanager.search.fluent.QueryKeysClient;
import com.azure.resourcemanager.search.fluent.ServicesClient;
import com.azure.resourcemanager.search.fluent.SharedPrivateLinkResourcesClient;
import com.azure.resourcemanager.search.fluent.UsagesClient;
import com.azure.resourcemanager.search.fluent.models.QuotaUsageResultInner;
import java.time.Duration;
import java.util.UUID;
import reactor.core.publisher.Mono;

public interface SearchManagementClient {
    public String getSubscriptionId();

    public String getEndpoint();

    public String getApiVersion();

    public HttpPipeline getHttpPipeline();

    public Duration getDefaultPollInterval();

    public OperationsClient getOperations();

    public AdminKeysClient getAdminKeys();

    public QueryKeysClient getQueryKeys();

    public ServicesClient getServices();

    public PrivateLinkResourcesClient getPrivateLinkResources();

    public PrivateEndpointConnectionsClient getPrivateEndpointConnections();

    public SharedPrivateLinkResourcesClient getSharedPrivateLinkResources();

    public UsagesClient getUsages();

    public NetworkSecurityPerimeterConfigurationsClient getNetworkSecurityPerimeterConfigurations();

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<QuotaUsageResultInner>> usageBySubscriptionSkuWithResponseAsync(String var1, String var2, UUID var3);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<QuotaUsageResultInner> usageBySubscriptionSkuAsync(String var1, String var2);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<QuotaUsageResultInner> usageBySubscriptionSkuWithResponse(String var1, String var2, UUID var3, Context var4);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public QuotaUsageResultInner usageBySubscriptionSku(String var1, String var2);
}

