// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.search.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Properties of Access Rule.
 */
@Fluent
public final class AccessRuleProperties implements JsonSerializable<AccessRuleProperties> {
    /*
     * Direction of Access Rule
     */
    private AccessRuleDirection direction;

    /*
     * Address prefixes in the CIDR format for inbound rules
     */
    private List<String> addressPrefixes;

    /*
     * Subscriptions for inbound rules
     */
    private List<AccessRulePropertiesSubscriptionsItem> subscriptions;

    /*
     * Network security perimeters for inbound rules
     */
    private List<NetworkSecurityPerimeter> networkSecurityPerimeters;

    /*
     * Fully qualified domain names (FQDN) for outbound rules
     */
    private List<String> fullyQualifiedDomainNames;

    /*
     * Email addresses for outbound rules
     */
    private List<String> emailAddresses;

    /*
     * Phone numbers for outbound rules
     */
    private List<String> phoneNumbers;

    /**
     * Creates an instance of AccessRuleProperties class.
     */
    public AccessRuleProperties() {
    }

    /**
     * Get the direction property: Direction of Access Rule.
     * 
     * @return the direction value.
     */
    public AccessRuleDirection direction() {
        return this.direction;
    }

    /**
     * Set the direction property: Direction of Access Rule.
     * 
     * @param direction the direction value to set.
     * @return the AccessRuleProperties object itself.
     */
    public AccessRuleProperties withDirection(AccessRuleDirection direction) {
        this.direction = direction;
        return this;
    }

    /**
     * Get the addressPrefixes property: Address prefixes in the CIDR format for inbound rules.
     * 
     * @return the addressPrefixes value.
     */
    public List<String> addressPrefixes() {
        return this.addressPrefixes;
    }

    /**
     * Set the addressPrefixes property: Address prefixes in the CIDR format for inbound rules.
     * 
     * @param addressPrefixes the addressPrefixes value to set.
     * @return the AccessRuleProperties object itself.
     */
    public AccessRuleProperties withAddressPrefixes(List<String> addressPrefixes) {
        this.addressPrefixes = addressPrefixes;
        return this;
    }

    /**
     * Get the subscriptions property: Subscriptions for inbound rules.
     * 
     * @return the subscriptions value.
     */
    public List<AccessRulePropertiesSubscriptionsItem> subscriptions() {
        return this.subscriptions;
    }

    /**
     * Set the subscriptions property: Subscriptions for inbound rules.
     * 
     * @param subscriptions the subscriptions value to set.
     * @return the AccessRuleProperties object itself.
     */
    public AccessRuleProperties withSubscriptions(List<AccessRulePropertiesSubscriptionsItem> subscriptions) {
        this.subscriptions = subscriptions;
        return this;
    }

    /**
     * Get the networkSecurityPerimeters property: Network security perimeters for inbound rules.
     * 
     * @return the networkSecurityPerimeters value.
     */
    public List<NetworkSecurityPerimeter> networkSecurityPerimeters() {
        return this.networkSecurityPerimeters;
    }

    /**
     * Set the networkSecurityPerimeters property: Network security perimeters for inbound rules.
     * 
     * @param networkSecurityPerimeters the networkSecurityPerimeters value to set.
     * @return the AccessRuleProperties object itself.
     */
    public AccessRuleProperties
        withNetworkSecurityPerimeters(List<NetworkSecurityPerimeter> networkSecurityPerimeters) {
        this.networkSecurityPerimeters = networkSecurityPerimeters;
        return this;
    }

    /**
     * Get the fullyQualifiedDomainNames property: Fully qualified domain names (FQDN) for outbound rules.
     * 
     * @return the fullyQualifiedDomainNames value.
     */
    public List<String> fullyQualifiedDomainNames() {
        return this.fullyQualifiedDomainNames;
    }

    /**
     * Set the fullyQualifiedDomainNames property: Fully qualified domain names (FQDN) for outbound rules.
     * 
     * @param fullyQualifiedDomainNames the fullyQualifiedDomainNames value to set.
     * @return the AccessRuleProperties object itself.
     */
    public AccessRuleProperties withFullyQualifiedDomainNames(List<String> fullyQualifiedDomainNames) {
        this.fullyQualifiedDomainNames = fullyQualifiedDomainNames;
        return this;
    }

    /**
     * Get the emailAddresses property: Email addresses for outbound rules.
     * 
     * @return the emailAddresses value.
     */
    public List<String> emailAddresses() {
        return this.emailAddresses;
    }

    /**
     * Set the emailAddresses property: Email addresses for outbound rules.
     * 
     * @param emailAddresses the emailAddresses value to set.
     * @return the AccessRuleProperties object itself.
     */
    public AccessRuleProperties withEmailAddresses(List<String> emailAddresses) {
        this.emailAddresses = emailAddresses;
        return this;
    }

    /**
     * Get the phoneNumbers property: Phone numbers for outbound rules.
     * 
     * @return the phoneNumbers value.
     */
    public List<String> phoneNumbers() {
        return this.phoneNumbers;
    }

    /**
     * Set the phoneNumbers property: Phone numbers for outbound rules.
     * 
     * @param phoneNumbers the phoneNumbers value to set.
     * @return the AccessRuleProperties object itself.
     */
    public AccessRuleProperties withPhoneNumbers(List<String> phoneNumbers) {
        this.phoneNumbers = phoneNumbers;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (subscriptions() != null) {
            subscriptions().forEach(e -> e.validate());
        }
        if (networkSecurityPerimeters() != null) {
            networkSecurityPerimeters().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("direction", this.direction == null ? null : this.direction.toString());
        jsonWriter.writeArrayField("addressPrefixes", this.addressPrefixes,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("subscriptions", this.subscriptions, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("networkSecurityPerimeters", this.networkSecurityPerimeters,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("fullyQualifiedDomainNames", this.fullyQualifiedDomainNames,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("emailAddresses", this.emailAddresses,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("phoneNumbers", this.phoneNumbers, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AccessRuleProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AccessRuleProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AccessRuleProperties.
     */
    public static AccessRuleProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AccessRuleProperties deserializedAccessRuleProperties = new AccessRuleProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("direction".equals(fieldName)) {
                    deserializedAccessRuleProperties.direction = AccessRuleDirection.fromString(reader.getString());
                } else if ("addressPrefixes".equals(fieldName)) {
                    List<String> addressPrefixes = reader.readArray(reader1 -> reader1.getString());
                    deserializedAccessRuleProperties.addressPrefixes = addressPrefixes;
                } else if ("subscriptions".equals(fieldName)) {
                    List<AccessRulePropertiesSubscriptionsItem> subscriptions
                        = reader.readArray(reader1 -> AccessRulePropertiesSubscriptionsItem.fromJson(reader1));
                    deserializedAccessRuleProperties.subscriptions = subscriptions;
                } else if ("networkSecurityPerimeters".equals(fieldName)) {
                    List<NetworkSecurityPerimeter> networkSecurityPerimeters
                        = reader.readArray(reader1 -> NetworkSecurityPerimeter.fromJson(reader1));
                    deserializedAccessRuleProperties.networkSecurityPerimeters = networkSecurityPerimeters;
                } else if ("fullyQualifiedDomainNames".equals(fieldName)) {
                    List<String> fullyQualifiedDomainNames = reader.readArray(reader1 -> reader1.getString());
                    deserializedAccessRuleProperties.fullyQualifiedDomainNames = fullyQualifiedDomainNames;
                } else if ("emailAddresses".equals(fieldName)) {
                    List<String> emailAddresses = reader.readArray(reader1 -> reader1.getString());
                    deserializedAccessRuleProperties.emailAddresses = emailAddresses;
                } else if ("phoneNumbers".equals(fieldName)) {
                    List<String> phoneNumbers = reader.readArray(reader1 -> reader1.getString());
                    deserializedAccessRuleProperties.phoneNumbers = phoneNumbers;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAccessRuleProperties;
        });
    }
}
