// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.search.models;

/**
 * Describes how a search service should enforce compliance if it finds objects that aren't encrypted with the
 * customer-managed key.
 */
public enum SearchEncryptionWithCmk {
    /**
     * Enum value Disabled.
     */
    DISABLED("Disabled"),

    /**
     * Enum value Enabled.
     */
    ENABLED("Enabled"),

    /**
     * Enum value Unspecified.
     */
    UNSPECIFIED("Unspecified");

    /**
     * The actual serialized value for a SearchEncryptionWithCmk instance.
     */
    private final String value;

    SearchEncryptionWithCmk(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a SearchEncryptionWithCmk instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed SearchEncryptionWithCmk object, or null if unable to parse.
     */
    public static SearchEncryptionWithCmk fromString(String value) {
        if (value == null) {
            return null;
        }
        SearchEncryptionWithCmk[] items = SearchEncryptionWithCmk.values();
        for (SearchEncryptionWithCmk item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return this.value;
    }
}
