// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.search.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.search.fluent.models.NetworkSecurityPerimeterConfigurationInner;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in
 * NetworkSecurityPerimeterConfigurationsClient.
 */
public interface NetworkSecurityPerimeterConfigurationsClient {
    /**
     * Gets a list of network security perimeter configurations for a search service.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure AI Search service associated with the specified resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of network security perimeter configurations for a search service as paginated response with
     * {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<NetworkSecurityPerimeterConfigurationInner> listByServiceAsync(String resourceGroupName,
        String searchServiceName);

    /**
     * Gets a list of network security perimeter configurations for a search service.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure AI Search service associated with the specified resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of network security perimeter configurations for a search service as paginated response with
     * {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<NetworkSecurityPerimeterConfigurationInner> listByService(String resourceGroupName,
        String searchServiceName);

    /**
     * Gets a list of network security perimeter configurations for a search service.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure AI Search service associated with the specified resource group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of network security perimeter configurations for a search service as paginated response with
     * {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<NetworkSecurityPerimeterConfigurationInner> listByService(String resourceGroupName,
        String searchServiceName, Context context);

    /**
     * Gets a network security perimeter configuration.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure AI Search service associated with the specified resource group.
     * @param nspConfigName The network security perimeter configuration name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a network security perimeter configuration along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<NetworkSecurityPerimeterConfigurationInner>> getWithResponseAsync(String resourceGroupName,
        String searchServiceName, String nspConfigName);

    /**
     * Gets a network security perimeter configuration.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure AI Search service associated with the specified resource group.
     * @param nspConfigName The network security perimeter configuration name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a network security perimeter configuration on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<NetworkSecurityPerimeterConfigurationInner> getAsync(String resourceGroupName, String searchServiceName,
        String nspConfigName);

    /**
     * Gets a network security perimeter configuration.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure AI Search service associated with the specified resource group.
     * @param nspConfigName The network security perimeter configuration name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a network security perimeter configuration along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<NetworkSecurityPerimeterConfigurationInner> getWithResponse(String resourceGroupName,
        String searchServiceName, String nspConfigName, Context context);

    /**
     * Gets a network security perimeter configuration.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure AI Search service associated with the specified resource group.
     * @param nspConfigName The network security perimeter configuration name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a network security perimeter configuration.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    NetworkSecurityPerimeterConfigurationInner get(String resourceGroupName, String searchServiceName,
        String nspConfigName);

    /**
     * Reconcile network security perimeter configuration for the Azure AI Search resource provider. This triggers a
     * manual resync with network security perimeter configurations by ensuring the search service carries the latest
     * configuration.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure AI Search service associated with the specified resource group.
     * @param nspConfigName The network security perimeter configuration name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> reconcileWithResponseAsync(String resourceGroupName, String searchServiceName,
        String nspConfigName);

    /**
     * Reconcile network security perimeter configuration for the Azure AI Search resource provider. This triggers a
     * manual resync with network security perimeter configurations by ensuring the search service carries the latest
     * configuration.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure AI Search service associated with the specified resource group.
     * @param nspConfigName The network security perimeter configuration name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginReconcileAsync(String resourceGroupName, String searchServiceName,
        String nspConfigName);

    /**
     * Reconcile network security perimeter configuration for the Azure AI Search resource provider. This triggers a
     * manual resync with network security perimeter configurations by ensuring the search service carries the latest
     * configuration.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure AI Search service associated with the specified resource group.
     * @param nspConfigName The network security perimeter configuration name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginReconcile(String resourceGroupName, String searchServiceName,
        String nspConfigName);

    /**
     * Reconcile network security perimeter configuration for the Azure AI Search resource provider. This triggers a
     * manual resync with network security perimeter configurations by ensuring the search service carries the latest
     * configuration.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure AI Search service associated with the specified resource group.
     * @param nspConfigName The network security perimeter configuration name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginReconcile(String resourceGroupName, String searchServiceName,
        String nspConfigName, Context context);

    /**
     * Reconcile network security perimeter configuration for the Azure AI Search resource provider. This triggers a
     * manual resync with network security perimeter configurations by ensuring the search service carries the latest
     * configuration.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure AI Search service associated with the specified resource group.
     * @param nspConfigName The network security perimeter configuration name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> reconcileAsync(String resourceGroupName, String searchServiceName, String nspConfigName);

    /**
     * Reconcile network security perimeter configuration for the Azure AI Search resource provider. This triggers a
     * manual resync with network security perimeter configurations by ensuring the search service carries the latest
     * configuration.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure AI Search service associated with the specified resource group.
     * @param nspConfigName The network security perimeter configuration name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void reconcile(String resourceGroupName, String searchServiceName, String nspConfigName);

    /**
     * Reconcile network security perimeter configuration for the Azure AI Search resource provider. This triggers a
     * manual resync with network security perimeter configurations by ensuring the search service carries the latest
     * configuration.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure AI Search service associated with the specified resource group.
     * @param nspConfigName The network security perimeter configuration name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void reconcile(String resourceGroupName, String searchServiceName, String nspConfigName, Context context);
}
