// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.search.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Possible origins of inbound traffic that can bypass the rules defined in the 'ipRules' section.
 */
public final class SearchBypass extends ExpandableStringEnum<SearchBypass> {
    /**
     * Static value None for SearchBypass.
     */
    public static final SearchBypass NONE = fromString("None");

    /**
     * Static value AzureServices for SearchBypass.
     */
    public static final SearchBypass AZURE_SERVICES = fromString("AzureServices");

    /**
     * Creates a new instance of SearchBypass value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public SearchBypass() {
    }

    /**
     * Creates or finds a SearchBypass from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding SearchBypass.
     */
    public static SearchBypass fromString(String name) {
        return fromString(name, SearchBypass.class);
    }

    /**
     * Gets known SearchBypass values.
     * 
     * @return known SearchBypass values.
     */
    public static Collection<SearchBypass> values() {
        return values(SearchBypass.class);
    }
}
