// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.search.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Network security configuration properties.
 */
@Fluent
public final class NetworkSecurityPerimeterConfigurationProperties
    implements JsonSerializable<NetworkSecurityPerimeterConfigurationProperties> {
    /*
     * Provisioning state of a network security perimeter configuration that is being created or updated.
     */
    private NetworkSecurityPerimeterConfigurationProvisioningState provisioningState;

    /*
     * List of provisioning issues, if any
     */
    private List<ProvisioningIssue> provisioningIssues;

    /*
     * Information about a network security perimeter (NSP)
     */
    private NetworkSecurityPerimeter networkSecurityPerimeter;

    /*
     * Information about resource association
     */
    private ResourceAssociation resourceAssociation;

    /*
     * Network security perimeter configuration profile
     */
    private NetworkSecurityProfile profile;

    /**
     * Creates an instance of NetworkSecurityPerimeterConfigurationProperties class.
     */
    public NetworkSecurityPerimeterConfigurationProperties() {
    }

    /**
     * Get the provisioningState property: Provisioning state of a network security perimeter configuration that is
     * being created or updated.
     * 
     * @return the provisioningState value.
     */
    public NetworkSecurityPerimeterConfigurationProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the provisioningIssues property: List of provisioning issues, if any.
     * 
     * @return the provisioningIssues value.
     */
    public List<ProvisioningIssue> provisioningIssues() {
        return this.provisioningIssues;
    }

    /**
     * Get the networkSecurityPerimeter property: Information about a network security perimeter (NSP).
     * 
     * @return the networkSecurityPerimeter value.
     */
    public NetworkSecurityPerimeter networkSecurityPerimeter() {
        return this.networkSecurityPerimeter;
    }

    /**
     * Set the networkSecurityPerimeter property: Information about a network security perimeter (NSP).
     * 
     * @param networkSecurityPerimeter the networkSecurityPerimeter value to set.
     * @return the NetworkSecurityPerimeterConfigurationProperties object itself.
     */
    public NetworkSecurityPerimeterConfigurationProperties
        withNetworkSecurityPerimeter(NetworkSecurityPerimeter networkSecurityPerimeter) {
        this.networkSecurityPerimeter = networkSecurityPerimeter;
        return this;
    }

    /**
     * Get the resourceAssociation property: Information about resource association.
     * 
     * @return the resourceAssociation value.
     */
    public ResourceAssociation resourceAssociation() {
        return this.resourceAssociation;
    }

    /**
     * Set the resourceAssociation property: Information about resource association.
     * 
     * @param resourceAssociation the resourceAssociation value to set.
     * @return the NetworkSecurityPerimeterConfigurationProperties object itself.
     */
    public NetworkSecurityPerimeterConfigurationProperties
        withResourceAssociation(ResourceAssociation resourceAssociation) {
        this.resourceAssociation = resourceAssociation;
        return this;
    }

    /**
     * Get the profile property: Network security perimeter configuration profile.
     * 
     * @return the profile value.
     */
    public NetworkSecurityProfile profile() {
        return this.profile;
    }

    /**
     * Set the profile property: Network security perimeter configuration profile.
     * 
     * @param profile the profile value to set.
     * @return the NetworkSecurityPerimeterConfigurationProperties object itself.
     */
    public NetworkSecurityPerimeterConfigurationProperties withProfile(NetworkSecurityProfile profile) {
        this.profile = profile;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (provisioningIssues() != null) {
            provisioningIssues().forEach(e -> e.validate());
        }
        if (networkSecurityPerimeter() != null) {
            networkSecurityPerimeter().validate();
        }
        if (resourceAssociation() != null) {
            resourceAssociation().validate();
        }
        if (profile() != null) {
            profile().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("networkSecurityPerimeter", this.networkSecurityPerimeter);
        jsonWriter.writeJsonField("resourceAssociation", this.resourceAssociation);
        jsonWriter.writeJsonField("profile", this.profile);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NetworkSecurityPerimeterConfigurationProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NetworkSecurityPerimeterConfigurationProperties if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the NetworkSecurityPerimeterConfigurationProperties.
     */
    public static NetworkSecurityPerimeterConfigurationProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NetworkSecurityPerimeterConfigurationProperties deserializedNetworkSecurityPerimeterConfigurationProperties
                = new NetworkSecurityPerimeterConfigurationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("provisioningState".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeterConfigurationProperties.provisioningState
                        = NetworkSecurityPerimeterConfigurationProvisioningState.fromString(reader.getString());
                } else if ("provisioningIssues".equals(fieldName)) {
                    List<ProvisioningIssue> provisioningIssues
                        = reader.readArray(reader1 -> ProvisioningIssue.fromJson(reader1));
                    deserializedNetworkSecurityPerimeterConfigurationProperties.provisioningIssues = provisioningIssues;
                } else if ("networkSecurityPerimeter".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeterConfigurationProperties.networkSecurityPerimeter
                        = NetworkSecurityPerimeter.fromJson(reader);
                } else if ("resourceAssociation".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeterConfigurationProperties.resourceAssociation
                        = ResourceAssociation.fromJson(reader);
                } else if ("profile".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeterConfigurationProperties.profile
                        = NetworkSecurityProfile.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNetworkSecurityPerimeterConfigurationProperties;
        });
    }
}
