// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.search.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.search.fluent.models.NetworkSecurityPerimeterConfigurationInner;
import java.io.IOException;
import java.util.List;

/**
 * Result of a list NSP (network security perimeter) configurations request.
 */
@Fluent
public final class NetworkSecurityPerimeterConfigurationListResult
    implements JsonSerializable<NetworkSecurityPerimeterConfigurationListResult> {
    /*
     * Array of network security perimeter results.
     */
    private List<NetworkSecurityPerimeterConfigurationInner> value;

    /*
     * The link used to get the next page of results.
     */
    private String nextLink;

    /**
     * Creates an instance of NetworkSecurityPerimeterConfigurationListResult class.
     */
    public NetworkSecurityPerimeterConfigurationListResult() {
    }

    /**
     * Get the value property: Array of network security perimeter results.
     * 
     * @return the value value.
     */
    public List<NetworkSecurityPerimeterConfigurationInner> value() {
        return this.value;
    }

    /**
     * Set the value property: Array of network security perimeter results.
     * 
     * @param value the value value to set.
     * @return the NetworkSecurityPerimeterConfigurationListResult object itself.
     */
    public NetworkSecurityPerimeterConfigurationListResult
        withValue(List<NetworkSecurityPerimeterConfigurationInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The link used to get the next page of results.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The link used to get the next page of results.
     * 
     * @param nextLink the nextLink value to set.
     * @return the NetworkSecurityPerimeterConfigurationListResult object itself.
     */
    public NetworkSecurityPerimeterConfigurationListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NetworkSecurityPerimeterConfigurationListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NetworkSecurityPerimeterConfigurationListResult if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the NetworkSecurityPerimeterConfigurationListResult.
     */
    public static NetworkSecurityPerimeterConfigurationListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NetworkSecurityPerimeterConfigurationListResult deserializedNetworkSecurityPerimeterConfigurationListResult
                = new NetworkSecurityPerimeterConfigurationListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<NetworkSecurityPerimeterConfigurationInner> value
                        = reader.readArray(reader1 -> NetworkSecurityPerimeterConfigurationInner.fromJson(reader1));
                    deserializedNetworkSecurityPerimeterConfigurationListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeterConfigurationListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNetworkSecurityPerimeterConfigurationListResult;
        });
    }
}
